/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.StatsSnapshot;
import com.squareup.picasso.Utils;

class Stats {
    private static final int CACHE_HIT = 0;
    private static final int CACHE_MISS = 1;
    private static final int BITMAP_DECODE_FINISHED = 2;
    private static final int BITMAP_TRANSFORMED_FINISHED = 3;
    private static final String STATS_THREAD_NAME = "Picasso-Stats";
    final HandlerThread statsThread;
    final Cache cache;
    final Handler handler;
    long cacheHits;
    long cacheMisses;
    long totalOriginalBitmapSize;
    long totalTransformedBitmapSize;
    long averageOriginalBitmapSize;
    long averageTransformedBitmapSize;
    int originalBitmapCount;
    int transformedBitmapCount;

    Stats(Cache cache) {
        this.cache = cache;
        this.statsThread = new HandlerThread(STATS_THREAD_NAME, 10);
        this.statsThread.start();
        this.handler = new StatsHandler(this.statsThread.getLooper(), this);
    }

    void dispatchBitmapDecoded(Bitmap bitmap) {
        this.processBitmap(bitmap, 2);
    }

    void dispatchBitmapTransformed(Bitmap bitmap) {
        this.processBitmap(bitmap, 3);
    }

    void dispatchCacheHit() {
        this.handler.sendEmptyMessage(0);
    }

    void dispatchCacheMiss() {
        this.handler.sendEmptyMessage(1);
    }

    void shutdown() {
        this.statsThread.quit();
    }

    void performCacheHit() {
        ++this.cacheHits;
    }

    void performCacheMiss() {
        ++this.cacheMisses;
    }

    void performBitmapDecoded(long l) {
        ++this.originalBitmapCount;
        this.totalOriginalBitmapSize += l;
        this.averageOriginalBitmapSize = Stats.getAverage(this.originalBitmapCount, this.totalOriginalBitmapSize);
    }

    void performBitmapTransformed(long l) {
        ++this.transformedBitmapCount;
        this.totalTransformedBitmapSize += l;
        this.averageTransformedBitmapSize = Stats.getAverage(this.originalBitmapCount, this.totalTransformedBitmapSize);
    }

    synchronized StatsSnapshot createSnapshot() {
        return new StatsSnapshot(this.cache.maxSize(), this.cache.size(), this.cacheHits, this.cacheMisses, this.totalOriginalBitmapSize, this.totalTransformedBitmapSize, this.averageOriginalBitmapSize, this.averageTransformedBitmapSize, this.originalBitmapCount, this.transformedBitmapCount, System.currentTimeMillis());
    }

    private void processBitmap(Bitmap bitmap, int n) {
        int n2 = Utils.getBitmapBytes(bitmap);
        this.handler.sendMessage(this.handler.obtainMessage(n, n2, 0));
    }

    private static long getAverage(int n, long l) {
        return l / (long)n;
    }

    private static class StatsHandler
    extends Handler {
        private final Stats stats;

        public StatsHandler(Looper looper, Stats stats) {
            super(looper);
            this.stats = stats;
        }

        public void handleMessage(final Message message) {
            switch (message.what) {
                case 0: {
                    this.stats.performCacheHit();
                    break;
                }
                case 1: {
                    this.stats.performCacheMiss();
                    break;
                }
                case 2: {
                    this.stats.performBitmapDecoded(message.arg1);
                    break;
                }
                case 3: {
                    this.stats.performBitmapTransformed(message.arg1);
                    break;
                }
                default: {
                    Picasso.HANDLER.post(new Runnable(){

                        public void run() {
                            throw new AssertionError((Object)("Unhandled stats message." + message.what));
                        }
                    });
                }
            }
        }
    }
}

