/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.cookie;

import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.cookie.MalformedCookieException;
import ch.boye.httpclientandroidlib.cookie.SetCookie;
import ch.boye.httpclientandroidlib.impl.cookie.AbstractCookieAttributeHandler;
import ch.boye.httpclientandroidlib.impl.cookie.DateParseException;
import ch.boye.httpclientandroidlib.impl.cookie.DateUtils;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Array of date patterns may not be null");
        }
        this.datepatterns = stringArray;
    }

    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        if (setCookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (string == null) {
            throw new MalformedCookieException("Missing value for expires attribute");
        }
        try {
            setCookie.setExpiryDate(DateUtils.parseDate(string, this.datepatterns));
        }
        catch (DateParseException dateParseException) {
            throw new MalformedCookieException("Unable to parse expires attribute: " + string);
        }
    }
}

