/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.util.Log;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.FilePicker;
import org.mozilla.gecko.GeckoActivityStatus;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoBatteryManager;
import org.mozilla.gecko.GeckoConnectivityReceiver;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.NotificationHelper;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.HomePanelsManager;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoApplication
extends Application
implements ContextGetter {
    private static final String LOG_TAG = "GeckoApplication";
    private static volatile GeckoApplication instance;
    private boolean mInBackground;
    private boolean mPausedGecko;
    private LightweightTheme mLightweightTheme;

    public GeckoApplication() {
        instance = this;
    }

    public static GeckoApplication get() {
        return instance;
    }

    public Context getContext() {
        return this;
    }

    public SharedPreferences getSharedPreferences() {
        return GeckoSharedPrefs.forApp((Context)this);
    }

    public void onConfigurationChanged(Configuration configuration) {
        Log.d((String)LOG_TAG, (String)("onConfigurationChanged: " + configuration.locale + ", background: " + this.mInBackground));
        if (this.mInBackground) {
            super.onConfigurationChanged(configuration);
            return;
        }
        try {
            BrowserLocaleManager.getInstance().correctLocale((Context)this, this.getResources(), configuration);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)LOG_TAG, (String)"Couldn't correct locale.", (Throwable)illegalStateException);
        }
        super.onConfigurationChanged(configuration);
    }

    public void onActivityPause(GeckoActivityStatus geckoActivityStatus) {
        this.mInBackground = true;
        if (!geckoActivityStatus.isFinishing() && !geckoActivityStatus.isGeckoActivityOpened()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createAppBackgroundingEvent());
            this.mPausedGecko = true;
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.expireHistory(GeckoApplication.this.getContentResolver(), BrowserContract.ExpirePriority.NORMAL);
                }
            });
        }
        GeckoConnectivityReceiver.getInstance().stop();
        GeckoNetworkManager.getInstance().stop();
    }

    public void onActivityResume(GeckoActivityStatus geckoActivityStatus) {
        if (this.mPausedGecko) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createAppForegroundingEvent());
            this.mPausedGecko = false;
        }
        Context context = this.getApplicationContext();
        GeckoBatteryManager.getInstance().start(context);
        GeckoConnectivityReceiver.getInstance().start(context);
        GeckoNetworkManager.getInstance().start(context);
        this.mInBackground = false;
    }

    public void onCreate() {
        Context context = this.getApplicationContext();
        HardwareUtils.init((Context)context);
        Clipboard.init((Context)context);
        FilePicker.init(context);
        GeckoLoader.loadMozGlue((Context)context);
        HomePanelsManager.getInstance().init(context);
        NotificationHelper.getInstance(context).init();
        super.onCreate();
    }

    public boolean isApplicationInBackground() {
        return this.mInBackground;
    }

    public LightweightTheme getLightweightTheme() {
        return this.mLightweightTheme;
    }

    public void prepareLightweightTheme() {
        this.mLightweightTheme = new LightweightTheme(this);
    }
}

