/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;

public class GeckoJavaSampler {
    private static final String LOGTAG = "JavaSampler";
    private static Thread sSamplingThread;
    private static SamplingThread sSamplingRunnable;
    private static Thread sMainThread;
    private static volatile boolean sLibsLoaded;

    private static native double getProfilerTime();

    @WrapElementForJNI(allowMultithread=true, stubName="GetThreadNameJavaProfilingWrapper")
    public static synchronized String getThreadName(int n) {
        if (n == 0 && sMainThread != null) {
            return sMainThread.getName();
        }
        return null;
    }

    private static synchronized Sample getSample(int n, int n2) {
        return GeckoJavaSampler.sSamplingRunnable.getSample(n, n2);
    }

    @WrapElementForJNI(allowMultithread=true, stubName="GetSampleTimeJavaProfiling")
    public static synchronized double getSampleTime(int n, int n2) {
        Sample sample = GeckoJavaSampler.getSample(n, n2);
        if (sample != null) {
            if (sample.mJavaTime != 0L) {
                return (double)(sample.mJavaTime - SystemClock.elapsedRealtime()) + GeckoJavaSampler.getProfilerTime();
            }
            System.out.println("Sample: " + sample.mTime);
            return sample.mTime;
        }
        return 0.0;
    }

    @WrapElementForJNI(allowMultithread=true, stubName="GetFrameNameJavaProfilingWrapper")
    public static synchronized String getFrameName(int n, int n2, int n3) {
        Sample sample = GeckoJavaSampler.getSample(n, n2);
        if (sample != null && n3 < sample.mFrames.length) {
            Frame frame = sample.mFrames[n3];
            if (frame == null) {
                return null;
            }
            return frame.className + "." + frame.methodName + "()";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapElementForJNI(allowMultithread=true, stubName="StartJavaProfiling")
    public static void start(int n, int n2) {
        Class<GeckoJavaSampler> clazz = GeckoJavaSampler.class;
        synchronized (GeckoJavaSampler.class) {
            if (sSamplingRunnable != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            sSamplingRunnable = new SamplingThread(n, n2);
            sSamplingThread = new Thread((Runnable)sSamplingRunnable, "Java Sampler");
            sSamplingThread.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapElementForJNI(allowMultithread=true, stubName="PauseJavaProfiling")
    public static void pause() {
        Class<GeckoJavaSampler> clazz = GeckoJavaSampler.class;
        synchronized (GeckoJavaSampler.class) {
            sSamplingRunnable.mPauseSampler = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapElementForJNI(allowMultithread=true, stubName="UnpauseJavaProfiling")
    public static void unpause() {
        Class<GeckoJavaSampler> clazz = GeckoJavaSampler.class;
        synchronized (GeckoJavaSampler.class) {
            sSamplingRunnable.mPauseSampler = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapElementForJNI(allowMultithread=true, stubName="StopJavaProfiling")
    public static void stop() {
        Class<GeckoJavaSampler> clazz = GeckoJavaSampler.class;
        synchronized (GeckoJavaSampler.class) {
            if (sSamplingThread == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            sSamplingRunnable.mStopSampler = true;
            try {
                sSamplingThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            sSamplingThread = null;
            sSamplingRunnable = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setLibsLoaded() {
        sLibsLoaded = true;
    }

    private static class SamplingThread
    implements Runnable {
        private final int mInterval;
        private final int mSampleCount;
        private boolean mPauseSampler;
        private boolean mStopSampler;
        private SparseArray<Sample[]> mSamples = new SparseArray();
        private int mSamplePos;

        public SamplingThread(int n, int n2) {
            this.mInterval = Math.max(10, n);
            this.mSampleCount = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Class<GeckoJavaSampler> clazz = GeckoJavaSampler.class;
            // MONITORENTER : org.mozilla.gecko.GeckoJavaSampler.class
            this.mSamples.put(0, (Object)new Sample[this.mSampleCount]);
            this.mSamplePos = 0;
            StackTraceElement[] stackTraceElementArray = Thread.getAllStackTraces().keySet();
            for (Thread thread : stackTraceElementArray) {
                if (thread.getName().compareToIgnoreCase("main") != 0) continue;
                sMainThread = thread;
                break;
            }
            if (sMainThread == null) {
                Log.e((String)GeckoJavaSampler.LOGTAG, (String)"Main thread not found");
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
            while (true) {
                try {
                    Thread.sleep(this.mInterval);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                clazz = GeckoJavaSampler.class;
                // MONITORENTER : org.mozilla.gecko.GeckoJavaSampler.class
                if (!this.mPauseSampler) {
                    stackTraceElementArray = sMainThread.getStackTrace();
                    ((Sample[])this.mSamples.get((int)0))[this.mSamplePos] = new Sample(stackTraceElementArray);
                    this.mSamplePos = (this.mSamplePos + 1) % ((Sample[])this.mSamples.get(0)).length;
                }
                if (this.mStopSampler) {
                    // MONITOREXIT : clazz
                    return;
                }
                // MONITOREXIT : clazz
            }
        }

        private Sample getSample(int n, int n2) {
            if (n < this.mSamples.size() && n2 < ((Sample[])this.mSamples.get(n)).length && ((Sample[])this.mSamples.get(n))[n2] != null) {
                int n3 = 0;
                if (((Sample[])this.mSamples.get(n))[this.mSamplePos] != null) {
                    n3 = this.mSamplePos;
                }
                int n4 = (n3 + n2) % ((Sample[])this.mSamples.get(n)).length;
                return ((Sample[])this.mSamples.get(n))[n4];
            }
            return null;
        }
    }

    private static class Frame {
        public String fileName;
        public int lineNo;
        public String methodName;
        public String className;

        private Frame() {
        }
    }

    private static class Sample {
        public Frame[] mFrames;
        public double mTime;
        public long mJavaTime;

        public Sample(StackTraceElement[] stackTraceElementArray) {
            this.mFrames = new Frame[stackTraceElementArray.length];
            if (sLibsLoaded) {
                this.mTime = GeckoJavaSampler.getProfilerTime();
            }
            if (this.mTime == 0.0) {
                this.mJavaTime = SystemClock.elapsedRealtime();
            }
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                this.mFrames[stackTraceElementArray.length - 1 - i] = new Frame();
                this.mFrames[stackTraceElementArray.length - 1 - i].fileName = stackTraceElementArray[i].getFileName();
                this.mFrames[stackTraceElementArray.length - 1 - i].lineNo = stackTraceElementArray[i].getLineNumber();
                this.mFrames[stackTraceElementArray.length - 1 - i].methodName = stackTraceElementArray[i].getMethodName();
                this.mFrames[stackTraceElementArray.length - 1 - i].className = stackTraceElementArray[i].getClassName();
            }
        }
    }
}

