/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.SystemClock;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.mozglue.RobocopTarget;

@RobocopTarget
public class Telemetry {
    private static final String LOGTAG = "Telemetry";

    public static long uptime() {
        return SystemClock.uptimeMillis();
    }

    public static long realtime() {
        return SystemClock.elapsedRealtime();
    }

    public static void HistogramAdd(String string2, int n) {
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryHistogramAddEvent(string2, n);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void startUISession(TelemetryContract.Session session, String string2) {
        String string3 = Telemetry.getSessionName(session, string2);
        Log.d((String)LOGTAG, (String)("StartUISession: " + string3));
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryUISessionStartEvent(string3, Telemetry.realtime());
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void startUISession(TelemetryContract.Session session) {
        Telemetry.startUISession(session, null);
    }

    public static void stopUISession(TelemetryContract.Session session, String string2, TelemetryContract.Reason reason) {
        String string3 = Telemetry.getSessionName(session, string2);
        Log.d((String)LOGTAG, (String)("StopUISession: " + string3 + ", reason=" + (Object)((Object)reason)));
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryUISessionStopEvent(string3, reason.toString(), Telemetry.realtime());
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void stopUISession(TelemetryContract.Session session, TelemetryContract.Reason reason) {
        Telemetry.stopUISession(session, null, reason);
    }

    public static void stopUISession(TelemetryContract.Session session, String string2) {
        Telemetry.stopUISession(session, string2, TelemetryContract.Reason.NONE);
    }

    public static void stopUISession(TelemetryContract.Session session) {
        Telemetry.stopUISession(session, null, TelemetryContract.Reason.NONE);
    }

    private static String getSessionName(TelemetryContract.Session session, String string2) {
        if (string2 != null) {
            return session.toString() + ":" + string2;
        }
        return session.toString();
    }

    private static void sendUIEvent(String string2, TelemetryContract.Method method, long l, String string3) {
        if (method == null) {
            throw new IllegalArgumentException("Expected non-null method - use Method.NONE?");
        }
        Log.d((String)LOGTAG, (String)("SendUIEvent: event = " + string2 + " method = " + (Object)((Object)method) + " timestamp = " + l + " extras = " + string3));
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryUIEvent(string2, method.toString(), l, string3);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void sendUIEvent(TelemetryContract.Event event, TelemetryContract.Method method, long l, String string2) {
        Telemetry.sendUIEvent(event.toString(), method, l, string2);
    }

    public static void sendUIEvent(TelemetryContract.Event event, TelemetryContract.Method method, long l) {
        Telemetry.sendUIEvent(event, method, l, null);
    }

    public static void sendUIEvent(TelemetryContract.Event event, TelemetryContract.Method method, String string2) {
        Telemetry.sendUIEvent(event, method, Telemetry.realtime(), string2);
    }

    public static void sendUIEvent(TelemetryContract.Event event, TelemetryContract.Method method) {
        Telemetry.sendUIEvent(event, method, Telemetry.realtime(), null);
    }

    public static void sendUIEvent(TelemetryContract.Event event) {
        Telemetry.sendUIEvent(event, TelemetryContract.Method.NONE, Telemetry.realtime(), null);
    }

    public static void sendUIEvent(TelemetryContract.Event event, boolean bl) {
        String string2 = (Object)((Object)event) + ":" + bl;
        Telemetry.sendUIEvent(string2, TelemetryContract.Method.NONE, Telemetry.realtime(), null);
    }

    public static class UptimeTimer
    extends Timer {
        public UptimeTimer(String string2) {
            super(string2);
        }

        protected long now() {
            return Telemetry.uptime();
        }
    }

    public static class RealtimeTimer
    extends Timer {
        public RealtimeTimer(String string2) {
            super(string2);
        }

        protected long now() {
            return Telemetry.realtime();
        }
    }

    public static abstract class Timer {
        private final long mStartTime;
        private final String mName;
        private volatile boolean mHasFinished;
        private volatile long mElapsed = -1L;

        protected abstract long now();

        public Timer(String string2) {
            this.mName = string2;
            this.mStartTime = this.now();
        }

        public void cancel() {
            this.mHasFinished = true;
        }

        public long getElapsed() {
            return this.mElapsed;
        }

        public void stop() {
            if (this.mHasFinished) {
                return;
            }
            this.mHasFinished = true;
            long l = this.now() - this.mStartTime;
            if (l < 0L) {
                Log.e((String)Telemetry.LOGTAG, (String)"Current time less than start time -- clock shenanigans?");
                return;
            }
            this.mElapsed = l;
            if (l > Integer.MAX_VALUE) {
                Log.e((String)Telemetry.LOGTAG, (String)("Duration of " + l + "ms is too great to add to histogram."));
                return;
            }
            Telemetry.HistogramAdd(this.mName, (int)l);
        }
    }
}

