/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.announcements;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.impl.cookie.DateUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.announcements.Announcement;
import org.mozilla.gecko.background.announcements.AnnouncementsFetchDelegate;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementsFetchResourceDelegate
extends BaseResourceDelegate {
    private static final String ACCEPT_HEADER = "application/json;charset=utf-8";
    private static final String LOG_TAG = "AnnounceFetchRD";
    protected final long startTime = System.currentTimeMillis();
    protected AnnouncementsFetchDelegate delegate;

    public AnnouncementsFetchResourceDelegate(Resource resource, AnnouncementsFetchDelegate announcementsFetchDelegate) {
        super(resource);
        this.delegate = announcementsFetchDelegate;
    }

    @Override
    public String getUserAgent() {
        return this.delegate.getUserAgent();
    }

    @Override
    public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
        super.addHeaders(httpRequestBase, defaultHttpClient);
        httpRequestBase.addHeader("Accept-Language", this.delegate.getLocale().toString());
        httpRequestBase.addHeader("Accept", ACCEPT_HEADER);
        httpRequestBase.addHeader("Connection", "close");
        String string2 = this.delegate.getLastDate();
        if (string2 != null) {
            Logger.info(LOG_TAG, "If-Modified-Since: " + string2);
            httpRequestBase.addHeader("If-Modified-Since", string2);
        }
        httpRequestBase.removeHeaders("Cookie");
    }

    private List<Announcement> parseBody(ExtendedJSONObject extendedJSONObject) throws NonArrayJSONException {
        ArrayList<Announcement> arrayList = new ArrayList<Announcement>(1);
        JSONArray jSONArray = extendedJSONObject.getArray("announcements");
        if (jSONArray == null) {
            Logger.warn(LOG_TAG, "Missing announcements body. Returning empty.");
            return arrayList;
        }
        for (Object e : jSONArray) {
            try {
                arrayList.add(Announcement.parseAnnouncement(new ExtendedJSONObject((JSONObject)e)));
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Malformed announcement or display failed. Skipping.", exception);
            }
        }
        return arrayList;
    }

    @Override
    public void handleHttpResponse(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Date");
        String string2 = null;
        if (header != null) {
            string2 = header.getValue();
        }
        if (string2 == null) {
            string2 = DateUtils.formatDate((Date)new Date());
            Logger.warn(LOG_TAG, "No fetch date; using local time " + string2);
        }
        SyncResponse syncResponse = new SyncResponse(httpResponse);
        try {
            int n = syncResponse.getStatusCode();
            Logger.debug(LOG_TAG, "Got announcements response: " + n);
            if (n == 204 || n == 304) {
                BaseResource.consumeEntity(httpResponse);
                this.delegate.onNoNewAnnouncements(this.startTime, string2);
                return;
            }
            if (n == 200) {
                List<Announcement> list;
                try {
                    list = this.parseBody(syncResponse.jsonObjectBody());
                }
                catch (Exception exception) {
                    this.delegate.onRemoteError(exception);
                    return;
                }
                this.delegate.onNewAnnouncements(list, this.startTime, string2);
                return;
            }
            if (n == 400 || n == 405) {
                Logger.warn(LOG_TAG, "We did something wrong. Oh dear.");
            }
            if (n == 503 || n == 500) {
                Logger.warn(LOG_TAG, "Server issue: " + syncResponse.body());
                this.delegate.onBackoff(syncResponse.retryAfterInSeconds());
                return;
            }
            this.delegate.onRemoteFailure(n);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Failed to extract body.", exception);
            this.delegate.onRemoteError(exception);
        }
    }

    @Override
    public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
        Logger.warn(LOG_TAG, "Protocol exception.", (Throwable)clientProtocolException);
        this.delegate.onLocalError((Exception)clientProtocolException);
    }

    @Override
    public void handleHttpIOException(IOException iOException) {
        Logger.warn(LOG_TAG, "IO exception.", iOException);
        this.delegate.onLocalError(iOException);
    }

    @Override
    public void handleTransportException(GeneralSecurityException generalSecurityException) {
        Logger.warn(LOG_TAG, "Transport exception.", generalSecurityException);
        this.delegate.onRemoteError(generalSecurityException);
    }

    @Override
    public AuthHeaderProvider getAuthHeaderProvider() {
        return null;
    }
}

