/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.nativecode.NativeCrypto;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.HKDF;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.crypto.PBKDF2;

public class FxAccountUtils {
    private static final String LOG_TAG = FxAccountUtils.class.getSimpleName();
    public static final int SALT_LENGTH_BYTES = 32;
    public static final int SALT_LENGTH_HEX = 64;
    public static final int HASH_LENGTH_BYTES = 16;
    public static final int HASH_LENGTH_HEX = 32;
    public static final int CRYPTO_KEY_LENGTH_BYTES = 32;
    public static final int CRYPTO_KEY_LENGTH_HEX = 64;
    public static final String KW_VERSION_STRING = "identity.mozilla.com/picl/v1/";
    public static final int NUMBER_OF_QUICK_STRETCH_ROUNDS = 1000;

    public static String bytes(String string2) throws UnsupportedEncodingException {
        return Utils.byte2Hex(string2.getBytes("UTF-8"));
    }

    public static byte[] KW(String string2) throws UnsupportedEncodingException {
        return Utils.concatAll(KW_VERSION_STRING.getBytes("UTF-8"), new byte[][]{string2.getBytes("UTF-8")});
    }

    public static byte[] KWE(String string2, byte[] byArray) throws UnsupportedEncodingException {
        return Utils.concatAll(KW_VERSION_STRING.getBytes("UTF-8"), string2.getBytes("UTF-8"), ":".getBytes("UTF-8"), byArray);
    }

    public static BigInteger srpVerifierLowercaseX(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray4 = Utils.sha256(Utils.concatAll(byArray, ":".getBytes("UTF-8"), byArray2));
        byte[] byArray5 = Utils.sha256(Utils.concatAll(byArray3, new byte[][]{byArray4}));
        return new BigInteger(1, byArray5);
    }

    public static BigInteger srpVerifierLowercaseV(byte[] byArray, byte[] byArray2, byte[] byArray3, BigInteger bigInteger, BigInteger bigInteger2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        BigInteger bigInteger3 = FxAccountUtils.srpVerifierLowercaseX(byArray, byArray2, byArray3);
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger3, bigInteger2);
        return bigInteger4;
    }

    public static String hexModN(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = (bigInteger2.bitLength() + 7) / 8;
        int n2 = 2 * n;
        return Utils.byte2Hex(Utils.hex2Byte(bigInteger.mod(bigInteger2).toString(16), n), n2);
    }

    public static KeyBundle generateSyncKeyBundle(byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = HKDF.derive(byArray, new byte[0], FxAccountUtils.KW("oldsync"), 64);
        System.arraycopy(byArray4, 0, byArray2, 0, 32);
        System.arraycopy(byArray4, 32, byArray3, 0, 32);
        return new KeyBundle(byArray2, byArray3);
    }

    public static byte[] generateQuickStretchedPW(byte[] byArray, byte[] byArray2) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] byArray3 = FxAccountUtils.KWE("quickStretch", byArray);
        try {
            return NativeCrypto.pbkdf2SHA256(byArray2, byArray3, 1000, 32);
        }
        catch (LinkageError linkageError) {
            Logger.warn(LOG_TAG, "Got throwable stretching password using native pbkdf2SHA256 implementation; ignoring and using Java implementation.", linkageError);
            return PBKDF2.pbkdf2SHA256(byArray2, byArray3, 1000, 32);
        }
    }

    public static byte[] generateAuthPW(byte[] byArray) throws GeneralSecurityException, UnsupportedEncodingException {
        return HKDF.derive(byArray, new byte[0], FxAccountUtils.KW("authPW"), 32);
    }

    public static byte[] generateUnwrapBKey(byte[] byArray) throws GeneralSecurityException, UnsupportedEncodingException {
        return HKDF.derive(byArray, new byte[0], FxAccountUtils.KW("unwrapBkey"), 32);
    }

    public static byte[] unwrapkB(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new IllegalArgumentException("unwrapkB must not be null");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("wrapkB must not be null");
        }
        if (byArray.length != 32 || byArray2.length != 32) {
            throw new IllegalArgumentException("unwrapkB and wrapkB must be 32 bytes long");
        }
        byte[] byArray3 = new byte[32];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray3[i] = (byte)(byArray2[i] ^ byArray[i]);
        }
        return byArray3;
    }

    public static String computeClientState(byte[] byArray) throws NoSuchAlgorithmException {
        if (byArray == null || byArray.length != 32) {
            throw new IllegalArgumentException("Unexpected kB.");
        }
        byte[] byArray2 = Utils.sha256(byArray);
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray2, 0, byArray3, 0, 16);
        return Utils.byte2Hex(byArray3);
    }

    public static String getAudienceForURL(String string2) throws URISyntaxException {
        URI uRI = new URI(string2);
        return new URI(uRI.getScheme(), uRI.getHost(), null, null).toString();
    }
}

