/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.util.Log;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.UrlConnectionDownloader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.mozilla.gecko.distribution.Distribution;

public class ImageLoader {
    private static final String LOGTAG = "GeckoImageLoader";
    private static final String DISTRIBUTION_SCHEME = "gecko.distribution";
    private static final String SUGGESTED_SITES_AUTHORITY = "suggestedsites";
    private static final float[] densityFactors = new float[]{1.0f, 2.0f, 1.5f, 0.5f};
    private static Picasso instance;

    public static synchronized Picasso with(Context context) {
        if (instance == null) {
            Picasso.Builder builder = new Picasso.Builder(context);
            Distribution distribution = Distribution.getInstance(context);
            builder.downloader((Downloader)new ImageDownloader(context, distribution));
            instance = builder.build();
        }
        return instance;
    }

    public static class ImageDownloader
    extends UrlConnectionDownloader {
        private final Context context;
        private final Distribution distribution;

        public ImageDownloader(Context context, Distribution distribution) {
            super(context);
            this.context = context;
            this.distribution = distribution;
        }

        private Density getDensity(float f) {
            DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
            float f2 = (float)displayMetrics.densityDpi * f;
            if (f2 >= 480.0f) {
                return Density.XXHDPI;
            }
            if (f2 >= 320.0f) {
                return Density.XHDPI;
            }
            if (f2 >= 240.0f) {
                return Density.HDPI;
            }
            return Density.MDPI;
        }

        public Downloader.Response load(Uri uri, boolean bl) throws IOException {
            String string2 = uri.getScheme();
            if (ImageLoader.DISTRIBUTION_SCHEME.equals(string2)) {
                return this.loadDistributionImage(uri);
            }
            return super.load(uri, bl);
        }

        private static String getPathForDensity(String string2, Density density, String string3) {
            File file = new File(string2, density.toString());
            return String.format("%s/%s.png", file.toString(), string3);
        }

        private Downloader.Response loadDistributionImage(Uri uri) throws IOException {
            String string2;
            String string3;
            String string4 = uri.getSchemeSpecificPart().substring(2);
            int n = string4.lastIndexOf(47);
            if (n == -1) {
                string3 = string4;
                string2 = "";
            } else {
                string3 = string4.substring(n + 1);
                string2 = string4.substring(0, n);
            }
            EnumSet<Density> enumSet = EnumSet.noneOf(Density.class);
            for (int i = 0; i < densityFactors.length; ++i) {
                Density density = this.getDensity(densityFactors[i]);
                if (!enumSet.add(density)) continue;
                String string5 = ImageDownloader.getPathForDensity(string2, density, string3);
                Log.d((String)ImageLoader.LOGTAG, (String)("Trying to load image from distribution " + string5));
                File file = this.distribution.getDistributionFile(string5);
                if (file == null) continue;
                return new Downloader.Response((InputStream)new FileInputStream(file), true);
            }
            throw new Downloader.ResponseException("Couldn't find suggested site image in distribution");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Density {
        MDPI,
        HDPI,
        XHDPI,
        XXHDPI;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

