/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.domain;

import android.content.ContentValues;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.db.Tab;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.domain.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabsRecord
extends Record {
    public static final String LOG_TAG = "TabsRecord";
    public static final String COLLECTION_NAME = "tabs";
    public static final long TABS_TTL = 604800L;
    public String clientName;
    public ArrayList<Tab> tabs;

    public TabsRecord(String string2, String string3, long l, boolean bl) {
        super(string2, string3, l, bl);
        this.ttl = 604800L;
    }

    public TabsRecord(String string2, String string3, long l) {
        this(string2, string3, l, false);
    }

    public TabsRecord(String string2, String string3) {
        this(string2, string3, 0L, false);
    }

    public TabsRecord(String string2) {
        this(string2, COLLECTION_NAME, 0L, false);
    }

    public TabsRecord() {
        this(Utils.generateGuid(), COLLECTION_NAME, 0L, false);
    }

    @Override
    public void initFromPayload(ExtendedJSONObject extendedJSONObject) {
        this.clientName = (String)extendedJSONObject.get("clientName");
        try {
            this.tabs = TabsRecord.tabsFrom(extendedJSONObject.getArray(COLLECTION_NAME));
        }
        catch (NonArrayJSONException nonArrayJSONException) {
            this.tabs = new ArrayList();
        }
    }

    protected static JSONArray tabsToJSON(ArrayList<Tab> arrayList) {
        JSONArray jSONArray = new JSONArray();
        for (Tab tab : arrayList) {
            jSONArray.add((Object)TabsRecord.tabToJSONObject(tab));
        }
        return jSONArray;
    }

    protected static ArrayList<Tab> tabsFrom(JSONArray jSONArray) {
        ArrayList<Tab> arrayList = new ArrayList<Tab>(jSONArray.size());
        for (Object e : jSONArray) {
            if (!(e instanceof JSONObject)) continue;
            try {
                arrayList.add(TabsRecord.tabFromJSONObject((JSONObject)e));
            }
            catch (NonArrayJSONException nonArrayJSONException) {
                Logger.warn(LOG_TAG, "urlHistory is not an array for this tab.", nonArrayJSONException);
            }
        }
        return arrayList;
    }

    @Override
    public void populatePayload(ExtendedJSONObject extendedJSONObject) {
        this.putPayload(extendedJSONObject, "id", this.guid);
        this.putPayload(extendedJSONObject, "clientName", this.clientName);
        extendedJSONObject.put(COLLECTION_NAME, TabsRecord.tabsToJSON(this.tabs));
    }

    @Override
    public Record copyWithIDs(String string2, long l) {
        TabsRecord tabsRecord = new TabsRecord(string2, this.collection, this.lastModified, this.deleted);
        tabsRecord.androidID = l;
        tabsRecord.sortIndex = this.sortIndex;
        tabsRecord.ttl = this.ttl;
        tabsRecord.clientName = this.clientName;
        tabsRecord.tabs = new ArrayList<Tab>(this.tabs);
        return tabsRecord;
    }

    public ContentValues getClientsContentValues() {
        ContentValues contentValues = new ContentValues();
        contentValues.put("guid", this.guid);
        contentValues.put("name", this.clientName);
        contentValues.put("last_modified", Long.valueOf(this.lastModified));
        return contentValues;
    }

    public ContentValues[] getTabsContentValues() {
        int n = this.tabs.size();
        ContentValues[] contentValuesArray = new ContentValues[n];
        for (int i = 0; i < n; ++i) {
            contentValuesArray[i] = this.tabs.get(i).toContentValues(this.guid, i);
        }
        return contentValuesArray;
    }

    public static Tab tabFromJSONObject(JSONObject jSONObject) throws NonArrayJSONException {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject(jSONObject);
        String string2 = extendedJSONObject.getString("title");
        String string3 = extendedJSONObject.getString("icon");
        JSONArray jSONArray = extendedJSONObject.getArray("urlHistory");
        long l = 0L;
        Object object = extendedJSONObject.get("lastUsed");
        if (object instanceof Number) {
            l = (Long)object * 1000L;
        } else if (object instanceof String) {
            try {
                l = Long.parseLong((String)object, 10) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                Logger.debug(LOG_TAG, "Invalid number format in lastUsed: " + object);
            }
        }
        return new Tab(string2, string3, jSONArray, l);
    }

    public static JSONObject tabToJSONObject(Tab tab) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"title", (Object)tab.title);
        jSONObject.put((Object)"icon", (Object)tab.icon);
        jSONObject.put((Object)"urlHistory", (Object)tab.history);
        jSONObject.put((Object)"lastUsed", (Object)(tab.lastUsed / 1000L));
        return jSONObject;
    }
}

