/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AndroidRuntimeException;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.FloatEvaluator;
import com.nineoldandroids.animation.IntEvaluator;
import com.nineoldandroids.animation.PropertyValuesHolder;
import com.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator {
    private static final long DEFAULT_FRAME_DELAY = 10L;
    static final int ANIMATION_START = 0;
    static final int ANIMATION_FRAME = 1;
    static final int STOPPED = 0;
    static final int RUNNING = 1;
    static final int SEEKED = 2;
    long mStartTime;
    long mSeekTime = -1L;
    private static ThreadLocal<AnimationHandler> sAnimationHandler = new ThreadLocal();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sPendingAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sDelayedAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sEndingAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sReadyAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final Interpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private boolean mPlayingBackwards = false;
    private int mCurrentIteration = 0;
    private float mCurrentFraction = 0.0f;
    private boolean mStartedDelay = false;
    private long mDelayStartTime;
    int mPlayingState = 0;
    private boolean mRunning = false;
    private boolean mStarted = false;
    boolean mInitialized = false;
    private long mDuration = 300L;
    private long mStartDelay = 0L;
    private static long sFrameDelay = 10L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private Interpolator mInterpolator = sDefaultInterpolator;
    private ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public static ValueAnimator ofInt(int ... nArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setIntValues(nArray);
        return valueAnimator;
    }

    public static ValueAnimator ofFloat(float ... fArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setFloatValues(fArray);
        return valueAnimator;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... propertyValuesHolderArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setValues(propertyValuesHolderArray);
        return valueAnimator;
    }

    public static ValueAnimator ofObject(TypeEvaluator typeEvaluator, Object ... objectArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setObjectValues(objectArray);
        valueAnimator.setEvaluator(typeEvaluator);
        return valueAnimator;
    }

    public void setIntValues(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", nArray));
        } else {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            propertyValuesHolder.setIntValues(nArray);
        }
        this.mInitialized = false;
    }

    public void setFloatValues(float ... fArray) {
        if (fArray == null || fArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", fArray));
        } else {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            propertyValuesHolder.setFloatValues(fArray);
        }
        this.mInitialized = false;
    }

    public void setObjectValues(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", (TypeEvaluator)null, objectArray));
        } else {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            propertyValuesHolder.setObjectValues(objectArray);
        }
        this.mInitialized = false;
    }

    public void setValues(PropertyValuesHolder ... propertyValuesHolderArray) {
        int n = propertyValuesHolderArray.length;
        this.mValues = propertyValuesHolderArray;
        this.mValuesMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            PropertyValuesHolder propertyValuesHolder = propertyValuesHolderArray[i];
            this.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
        }
        this.mInitialized = false;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            int n = this.mValues.length;
            for (int i = 0; i < n; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    public ValueAnimator setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + l);
        }
        this.mDuration = l;
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setCurrentPlayTime(long l) {
        this.initAnimation();
        long l2 = AnimationUtils.currentAnimationTimeMillis();
        if (this.mPlayingState != 1) {
            this.mSeekTime = l;
            this.mPlayingState = 2;
        }
        this.mStartTime = l2 - l;
        this.animationFrame(l2);
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || this.mPlayingState == 0) {
            return 0L;
        }
        return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    public void setStartDelay(long l) {
        this.mStartDelay = l;
    }

    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static void setFrameDelay(long l) {
        sFrameDelay = l;
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String string) {
        PropertyValuesHolder propertyValuesHolder = this.mValuesMap.get(string);
        if (propertyValuesHolder != null) {
            return propertyValuesHolder.getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int n) {
        this.mRepeatCount = n;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int n) {
        this.mRepeatMode = n;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(animatorUpdateListener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(animatorUpdateListener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator != null ? interpolator : new LinearInterpolator();
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        if (typeEvaluator != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(typeEvaluator);
        }
    }

    private void start(boolean bl) {
        Object object;
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mPlayingBackwards = bl;
        this.mCurrentIteration = 0;
        this.mPlayingState = 0;
        this.mStarted = true;
        this.mStartedDelay = false;
        sPendingAnimations.get().add(this);
        if (this.mStartDelay == 0L) {
            this.setCurrentPlayTime(this.getCurrentPlayTime());
            this.mPlayingState = 0;
            this.mRunning = true;
            if (this.mListeners != null) {
                object = (ArrayList)this.mListeners.clone();
                int n = ((ArrayList)object).size();
                for (int i = 0; i < n; ++i) {
                    ((Animator.AnimatorListener)((ArrayList)object).get(i)).onAnimationStart(this);
                }
            }
        }
        if ((object = sAnimationHandler.get()) == null) {
            object = new AnimationHandler();
            sAnimationHandler.set((AnimationHandler)((Object)object));
        }
        object.sendEmptyMessage(0);
    }

    public void start() {
        this.start(false);
    }

    public void cancel() {
        if (this.mPlayingState != 0 || sPendingAnimations.get().contains(this) || sDelayedAnims.get().contains(this)) {
            if (this.mRunning && this.mListeners != null) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener animatorListener : arrayList) {
                    animatorListener.onAnimationCancel(this);
                }
            }
            this.endAnimation();
        }
    }

    public void end() {
        if (!sAnimations.get().contains(this) && !sPendingAnimations.get().contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation();
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        if (this.mRepeatCount > 0 && (this.mRepeatCount & 1) == 1) {
            this.animateValue(0.0f);
        } else {
            this.animateValue(1.0f);
        }
        this.endAnimation();
    }

    public boolean isRunning() {
        return this.mPlayingState == 1 || this.mRunning;
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public void reverse() {
        boolean bl = this.mPlayingBackwards = !this.mPlayingBackwards;
        if (this.mPlayingState == 1) {
            long l = AnimationUtils.currentAnimationTimeMillis();
            long l2 = l - this.mStartTime;
            long l3 = this.mDuration - l2;
            this.mStartTime = l - l3;
        } else {
            this.start(true);
        }
    }

    private void endAnimation() {
        sAnimations.get().remove(this);
        sPendingAnimations.get().remove(this);
        sDelayedAnims.get().remove(this);
        this.mPlayingState = 0;
        if (this.mRunning && this.mListeners != null) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((Animator.AnimatorListener)arrayList.get(i)).onAnimationEnd(this);
            }
        }
        this.mRunning = false;
        this.mStarted = false;
    }

    private void startAnimation() {
        this.initAnimation();
        sAnimations.get().add(this);
        if (this.mStartDelay > 0L && this.mListeners != null) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((Animator.AnimatorListener)arrayList.get(i)).onAnimationStart(this);
            }
        }
    }

    private boolean delayedAnimationFrame(long l) {
        if (!this.mStartedDelay) {
            this.mStartedDelay = true;
            this.mDelayStartTime = l;
        } else {
            long l2 = l - this.mDelayStartTime;
            if (l2 > this.mStartDelay) {
                this.mStartTime = l - (l2 - this.mStartDelay);
                this.mPlayingState = 1;
                return true;
            }
        }
        return false;
    }

    boolean animationFrame(long l) {
        boolean bl = false;
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekTime < 0L) {
                this.mStartTime = l;
            } else {
                this.mStartTime = l - this.mSeekTime;
                this.mSeekTime = -1L;
            }
        }
        switch (this.mPlayingState) {
            case 1: 
            case 2: {
                float f;
                float f2 = f = this.mDuration > 0L ? (float)(l - this.mStartTime) / (float)this.mDuration : 1.0f;
                if (f >= 1.0f) {
                    if (this.mCurrentIteration < this.mRepeatCount || this.mRepeatCount == -1) {
                        if (this.mListeners != null) {
                            int n = this.mListeners.size();
                            for (int i = 0; i < n; ++i) {
                                ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                            }
                        }
                        if (this.mRepeatMode == 2) {
                            this.mPlayingBackwards = !this.mPlayingBackwards;
                        }
                        this.mCurrentIteration += (int)f;
                        f %= 1.0f;
                        this.mStartTime += this.mDuration;
                    } else {
                        bl = true;
                        f = Math.min(f, 1.0f);
                    }
                }
                if (this.mPlayingBackwards) {
                    f = 1.0f - f;
                }
                this.animateValue(f);
            }
        }
        return bl;
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    void animateValue(float f) {
        int n;
        this.mCurrentFraction = f = this.mInterpolator.getInterpolation(f);
        int n2 = this.mValues.length;
        for (n = 0; n < n2; ++n) {
            this.mValues[n].calculateValue(f);
        }
        if (this.mUpdateListeners != null) {
            n = this.mUpdateListeners.size();
            for (int i = 0; i < n; ++i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }
    }

    public ValueAnimator clone() {
        int n;
        int n2;
        PropertyValuesHolder[] propertyValuesHolderArray;
        ValueAnimator valueAnimator = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            propertyValuesHolderArray = this.mUpdateListeners;
            valueAnimator.mUpdateListeners = new ArrayList();
            n2 = propertyValuesHolderArray.size();
            for (n = 0; n < n2; ++n) {
                valueAnimator.mUpdateListeners.add(propertyValuesHolderArray.get(n));
            }
        }
        valueAnimator.mSeekTime = -1L;
        valueAnimator.mPlayingBackwards = false;
        valueAnimator.mCurrentIteration = 0;
        valueAnimator.mInitialized = false;
        valueAnimator.mPlayingState = 0;
        valueAnimator.mStartedDelay = false;
        propertyValuesHolderArray = this.mValues;
        if (propertyValuesHolderArray != null) {
            n2 = propertyValuesHolderArray.length;
            valueAnimator.mValues = new PropertyValuesHolder[n2];
            valueAnimator.mValuesMap = new HashMap(n2);
            for (n = 0; n < n2; ++n) {
                PropertyValuesHolder propertyValuesHolder;
                valueAnimator.mValues[n] = propertyValuesHolder = propertyValuesHolderArray[n].clone();
                valueAnimator.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
            }
        }
        return valueAnimator;
    }

    public static int getCurrentAnimationsCount() {
        return sAnimations.get().size();
    }

    public static void clearAllAnimations() {
        sAnimations.get().clear();
        sPendingAnimations.get().clear();
        sDelayedAnims.get().clear();
    }

    public String toString() {
        String string = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                string = string + "\n    " + this.mValues[i].toString();
            }
        }
        return string;
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }

    private static class AnimationHandler
    extends Handler {
        private AnimationHandler() {
        }

        public void handleMessage(Message message) {
            boolean bl = true;
            ArrayList arrayList = (ArrayList)sAnimations.get();
            ArrayList arrayList2 = (ArrayList)sDelayedAnims.get();
            switch (message.what) {
                case 0: {
                    Cloneable cloneable;
                    ArrayList arrayList3 = (ArrayList)sPendingAnimations.get();
                    if (arrayList.size() > 0 || arrayList2.size() > 0) {
                        bl = false;
                    }
                    while (arrayList3.size() > 0) {
                        ArrayList arrayList4 = (ArrayList)arrayList3.clone();
                        arrayList3.clear();
                        int n = arrayList4.size();
                        for (int i = 0; i < n; ++i) {
                            cloneable = (ValueAnimator)arrayList4.get(i);
                            if (((ValueAnimator)cloneable).mStartDelay == 0L) {
                                ((ValueAnimator)cloneable).startAnimation();
                                continue;
                            }
                            arrayList2.add(cloneable);
                        }
                    }
                }
                case 1: {
                    int n;
                    long l = AnimationUtils.currentAnimationTimeMillis();
                    ArrayList arrayList5 = (ArrayList)sReadyAnims.get();
                    Cloneable cloneable = (ArrayList)sEndingAnims.get();
                    int n2 = arrayList2.size();
                    for (n = 0; n < n2; ++n) {
                        ValueAnimator valueAnimator = (ValueAnimator)arrayList2.get(n);
                        if (!valueAnimator.delayedAnimationFrame(l)) continue;
                        arrayList5.add(valueAnimator);
                    }
                    n = arrayList5.size();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            ValueAnimator valueAnimator = (ValueAnimator)arrayList5.get(i);
                            valueAnimator.startAnimation();
                            valueAnimator.mRunning = true;
                            arrayList2.remove(valueAnimator);
                        }
                        arrayList5.clear();
                    }
                    int n3 = arrayList.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        ValueAnimator valueAnimator = (ValueAnimator)arrayList.get(n4);
                        if (valueAnimator.animationFrame(l)) {
                            ((ArrayList)cloneable).add(valueAnimator);
                        }
                        if (arrayList.size() == n3) {
                            ++n4;
                            continue;
                        }
                        --n3;
                        ((ArrayList)cloneable).remove(valueAnimator);
                    }
                    if (((ArrayList)cloneable).size() > 0) {
                        for (n4 = 0; n4 < ((ArrayList)cloneable).size(); ++n4) {
                            ((ValueAnimator)((ArrayList)cloneable).get(n4)).endAnimation();
                        }
                        ((ArrayList)cloneable).clear();
                    }
                    if (!bl || arrayList.isEmpty() && arrayList2.isEmpty()) break;
                    this.sendEmptyMessageDelayed(1, Math.max(0L, sFrameDelay - (AnimationUtils.currentAnimationTimeMillis() - l)));
                }
            }
        }
    }
}

