/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.view;

import android.view.View;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewPropertyAnimator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

class ViewPropertyAnimatorHC
extends ViewPropertyAnimator {
    private final WeakReference<View> mView;
    private long mDuration;
    private boolean mDurationSet = false;
    private long mStartDelay = 0L;
    private boolean mStartDelaySet = false;
    private Interpolator mInterpolator;
    private boolean mInterpolatorSet = false;
    private Animator.AnimatorListener mListener = null;
    private AnimatorEventListener mAnimatorEventListener = new AnimatorEventListener();
    ArrayList<NameValuesHolder> mPendingAnimations = new ArrayList();
    private static final int NONE = 0;
    private static final int TRANSLATION_X = 1;
    private static final int TRANSLATION_Y = 2;
    private static final int SCALE_X = 4;
    private static final int SCALE_Y = 8;
    private static final int ROTATION = 16;
    private static final int ROTATION_X = 32;
    private static final int ROTATION_Y = 64;
    private static final int X = 128;
    private static final int Y = 256;
    private static final int ALPHA = 512;
    private static final int TRANSFORM_MASK = 511;
    private Runnable mAnimationStarter = new Runnable(){

        public void run() {
            ViewPropertyAnimatorHC.this.startAnimation();
        }
    };
    private HashMap<Animator, PropertyBundle> mAnimatorMap = new HashMap();

    ViewPropertyAnimatorHC(View view) {
        this.mView = new WeakReference<View>(view);
    }

    public ViewPropertyAnimator setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + l);
        }
        this.mDurationSet = true;
        this.mDuration = l;
        return this;
    }

    public long getDuration() {
        if (this.mDurationSet) {
            return this.mDuration;
        }
        return new ValueAnimator().getDuration();
    }

    public long getStartDelay() {
        if (this.mStartDelaySet) {
            return this.mStartDelay;
        }
        return 0L;
    }

    public ViewPropertyAnimator setStartDelay(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + l);
        }
        this.mStartDelaySet = true;
        this.mStartDelay = l;
        return this;
    }

    public ViewPropertyAnimator setInterpolator(Interpolator interpolator) {
        this.mInterpolatorSet = true;
        this.mInterpolator = interpolator;
        return this;
    }

    public ViewPropertyAnimator setListener(Animator.AnimatorListener animatorListener) {
        this.mListener = animatorListener;
        return this;
    }

    public void start() {
        this.startAnimation();
    }

    public void cancel() {
        HashMap hashMap;
        if (this.mAnimatorMap.size() > 0) {
            hashMap = (HashMap)this.mAnimatorMap.clone();
            Set set = hashMap.keySet();
            for (Animator animator : set) {
                animator.cancel();
            }
        }
        this.mPendingAnimations.clear();
        hashMap = (View)this.mView.get();
        if (hashMap != null) {
            hashMap.removeCallbacks(this.mAnimationStarter);
        }
    }

    public ViewPropertyAnimator x(float f) {
        this.animateProperty(128, f);
        return this;
    }

    public ViewPropertyAnimator xBy(float f) {
        this.animatePropertyBy(128, f);
        return this;
    }

    public ViewPropertyAnimator y(float f) {
        this.animateProperty(256, f);
        return this;
    }

    public ViewPropertyAnimator yBy(float f) {
        this.animatePropertyBy(256, f);
        return this;
    }

    public ViewPropertyAnimator rotation(float f) {
        this.animateProperty(16, f);
        return this;
    }

    public ViewPropertyAnimator rotationBy(float f) {
        this.animatePropertyBy(16, f);
        return this;
    }

    public ViewPropertyAnimator rotationX(float f) {
        this.animateProperty(32, f);
        return this;
    }

    public ViewPropertyAnimator rotationXBy(float f) {
        this.animatePropertyBy(32, f);
        return this;
    }

    public ViewPropertyAnimator rotationY(float f) {
        this.animateProperty(64, f);
        return this;
    }

    public ViewPropertyAnimator rotationYBy(float f) {
        this.animatePropertyBy(64, f);
        return this;
    }

    public ViewPropertyAnimator translationX(float f) {
        this.animateProperty(1, f);
        return this;
    }

    public ViewPropertyAnimator translationXBy(float f) {
        this.animatePropertyBy(1, f);
        return this;
    }

    public ViewPropertyAnimator translationY(float f) {
        this.animateProperty(2, f);
        return this;
    }

    public ViewPropertyAnimator translationYBy(float f) {
        this.animatePropertyBy(2, f);
        return this;
    }

    public ViewPropertyAnimator scaleX(float f) {
        this.animateProperty(4, f);
        return this;
    }

    public ViewPropertyAnimator scaleXBy(float f) {
        this.animatePropertyBy(4, f);
        return this;
    }

    public ViewPropertyAnimator scaleY(float f) {
        this.animateProperty(8, f);
        return this;
    }

    public ViewPropertyAnimator scaleYBy(float f) {
        this.animatePropertyBy(8, f);
        return this;
    }

    public ViewPropertyAnimator alpha(float f) {
        this.animateProperty(512, f);
        return this;
    }

    public ViewPropertyAnimator alphaBy(float f) {
        this.animatePropertyBy(512, f);
        return this;
    }

    private void startAnimation() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(1.0f);
        ArrayList arrayList = (ArrayList)this.mPendingAnimations.clone();
        this.mPendingAnimations.clear();
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            NameValuesHolder nameValuesHolder = (NameValuesHolder)arrayList.get(i);
            n |= nameValuesHolder.mNameConstant;
        }
        this.mAnimatorMap.put(valueAnimator, new PropertyBundle(n, arrayList));
        valueAnimator.addUpdateListener(this.mAnimatorEventListener);
        valueAnimator.addListener(this.mAnimatorEventListener);
        if (this.mStartDelaySet) {
            valueAnimator.setStartDelay(this.mStartDelay);
        }
        if (this.mDurationSet) {
            valueAnimator.setDuration(this.mDuration);
        }
        if (this.mInterpolatorSet) {
            valueAnimator.setInterpolator(this.mInterpolator);
        }
        valueAnimator.start();
    }

    private void animateProperty(int n, float f) {
        float f2 = this.getValue(n);
        float f3 = f - f2;
        this.animatePropertyBy(n, f2, f3);
    }

    private void animatePropertyBy(int n, float f) {
        float f2 = this.getValue(n);
        this.animatePropertyBy(n, f2, f);
    }

    private void animatePropertyBy(int n, float f, float f2) {
        View view;
        Object object;
        if (this.mAnimatorMap.size() > 0) {
            object = null;
            view = this.mAnimatorMap.keySet();
            for (Animator animator : view) {
                PropertyBundle propertyBundle = this.mAnimatorMap.get(animator);
                if (!propertyBundle.cancel(n) || propertyBundle.mPropertyMask != 0) continue;
                object = animator;
                break;
            }
            if (object != null) {
                ((Animator)object).cancel();
            }
        }
        object = new NameValuesHolder(n, f, f2);
        this.mPendingAnimations.add((NameValuesHolder)object);
        view = (View)this.mView.get();
        if (view != null) {
            view.removeCallbacks(this.mAnimationStarter);
            view.post(this.mAnimationStarter);
        }
    }

    private void setValue(int n, float f) {
        View view = (View)this.mView.get();
        if (view != null) {
            switch (n) {
                case 1: {
                    view.setTranslationX(f);
                    break;
                }
                case 2: {
                    view.setTranslationY(f);
                    break;
                }
                case 16: {
                    view.setRotation(f);
                    break;
                }
                case 32: {
                    view.setRotationX(f);
                    break;
                }
                case 64: {
                    view.setRotationY(f);
                    break;
                }
                case 4: {
                    view.setScaleX(f);
                    break;
                }
                case 8: {
                    view.setScaleY(f);
                    break;
                }
                case 128: {
                    view.setX(f);
                    break;
                }
                case 256: {
                    view.setY(f);
                    break;
                }
                case 512: {
                    view.setAlpha(f);
                }
            }
        }
    }

    private float getValue(int n) {
        View view = (View)this.mView.get();
        if (view != null) {
            switch (n) {
                case 1: {
                    return view.getTranslationX();
                }
                case 2: {
                    return view.getTranslationY();
                }
                case 16: {
                    return view.getRotation();
                }
                case 32: {
                    return view.getRotationX();
                }
                case 64: {
                    return view.getRotationY();
                }
                case 4: {
                    return view.getScaleX();
                }
                case 8: {
                    return view.getScaleY();
                }
                case 128: {
                    return view.getX();
                }
                case 256: {
                    return view.getY();
                }
                case 512: {
                    return view.getAlpha();
                }
            }
        }
        return 0.0f;
    }

    private class AnimatorEventListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private AnimatorEventListener() {
        }

        public void onAnimationStart(Animator animator) {
            if (ViewPropertyAnimatorHC.this.mListener != null) {
                ViewPropertyAnimatorHC.this.mListener.onAnimationStart(animator);
            }
        }

        public void onAnimationCancel(Animator animator) {
            if (ViewPropertyAnimatorHC.this.mListener != null) {
                ViewPropertyAnimatorHC.this.mListener.onAnimationCancel(animator);
            }
        }

        public void onAnimationRepeat(Animator animator) {
            if (ViewPropertyAnimatorHC.this.mListener != null) {
                ViewPropertyAnimatorHC.this.mListener.onAnimationRepeat(animator);
            }
        }

        public void onAnimationEnd(Animator animator) {
            if (ViewPropertyAnimatorHC.this.mListener != null) {
                ViewPropertyAnimatorHC.this.mListener.onAnimationEnd(animator);
            }
            ViewPropertyAnimatorHC.this.mAnimatorMap.remove(animator);
            if (ViewPropertyAnimatorHC.this.mAnimatorMap.isEmpty()) {
                ViewPropertyAnimatorHC.this.mListener = null;
            }
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            View view;
            View view2;
            float f = valueAnimator.getAnimatedFraction();
            PropertyBundle propertyBundle = (PropertyBundle)ViewPropertyAnimatorHC.this.mAnimatorMap.get(valueAnimator);
            int n = propertyBundle.mPropertyMask;
            if ((n & 0x1FF) != 0 && (view2 = (View)ViewPropertyAnimatorHC.this.mView.get()) != null) {
                view2.invalidate();
            }
            if ((view2 = propertyBundle.mNameValuesHolder) != null) {
                int n2 = view2.size();
                for (int i = 0; i < n2; ++i) {
                    NameValuesHolder nameValuesHolder = (NameValuesHolder)view2.get(i);
                    float f2 = nameValuesHolder.mFromValue + f * nameValuesHolder.mDeltaValue;
                    ViewPropertyAnimatorHC.this.setValue(nameValuesHolder.mNameConstant, f2);
                }
            }
            if ((view = (View)ViewPropertyAnimatorHC.this.mView.get()) != null) {
                view.invalidate();
            }
        }
    }

    private static class NameValuesHolder {
        int mNameConstant;
        float mFromValue;
        float mDeltaValue;

        NameValuesHolder(int n, float f, float f2) {
            this.mNameConstant = n;
            this.mFromValue = f;
            this.mDeltaValue = f2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyBundle {
        int mPropertyMask;
        ArrayList<NameValuesHolder> mNameValuesHolder;

        PropertyBundle(int n, ArrayList<NameValuesHolder> arrayList) {
            this.mPropertyMask = n;
            this.mNameValuesHolder = arrayList;
        }

        boolean cancel(int n) {
            if ((this.mPropertyMask & n) != 0 && this.mNameValuesHolder != null) {
                int n2 = this.mNameValuesHolder.size();
                for (int i = 0; i < n2; ++i) {
                    NameValuesHolder nameValuesHolder = this.mNameValuesHolder.get(i);
                    if (nameValuesHolder.mNameConstant != n) continue;
                    this.mNameValuesHolder.remove(i);
                    this.mPropertyMask &= ~n;
                    return true;
                }
            }
            return false;
        }
    }
}

