/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.params;

import ch.boye.httpclientandroidlib.params.CoreConnectionPNames;
import ch.boye.httpclientandroidlib.params.HttpParams;

public final class HttpConnectionParams
implements CoreConnectionPNames {
    private HttpConnectionParams() {
    }

    public static int getSoTimeout(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getIntParameter("http.socket.timeout", 0);
    }

    public static void setSoTimeout(HttpParams httpParams, int n) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setIntParameter("http.socket.timeout", n);
    }

    public static boolean getSoReuseaddr(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getBooleanParameter("http.socket.reuseaddr", false);
    }

    public static void setSoReuseaddr(HttpParams httpParams, boolean bl) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setBooleanParameter("http.socket.reuseaddr", bl);
    }

    public static boolean getTcpNoDelay(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getBooleanParameter("http.tcp.nodelay", true);
    }

    public static void setTcpNoDelay(HttpParams httpParams, boolean bl) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setBooleanParameter("http.tcp.nodelay", bl);
    }

    public static int getSocketBufferSize(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getIntParameter("http.socket.buffer-size", -1);
    }

    public static void setSocketBufferSize(HttpParams httpParams, int n) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setIntParameter("http.socket.buffer-size", n);
    }

    public static int getLinger(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getIntParameter("http.socket.linger", -1);
    }

    public static void setLinger(HttpParams httpParams, int n) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setIntParameter("http.socket.linger", n);
    }

    public static int getConnectionTimeout(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getIntParameter("http.connection.timeout", 0);
    }

    public static void setConnectionTimeout(HttpParams httpParams, int n) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setIntParameter("http.connection.timeout", n);
    }

    public static boolean isStaleCheckingEnabled(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getBooleanParameter("http.connection.stalecheck", true);
    }

    public static void setStaleCheckingEnabled(HttpParams httpParams, boolean bl) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setBooleanParameter("http.connection.stalecheck", bl);
    }
}

