/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.os.Handler;
import android.os.Looper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UiAsyncTask<Params, Progress, Result> {
    private volatile boolean mCancelled;
    private final Handler mBackgroundThreadHandler;
    private static Handler sHandler;

    public UiAsyncTask(Handler handler) {
        this.mBackgroundThreadHandler = handler;
    }

    private static synchronized Handler getUiHandler() {
        if (sHandler == null) {
            sHandler = new Handler(Looper.getMainLooper());
        }
        return sHandler;
    }

    public final void execute(final Params ... ParamsArray) {
        UiAsyncTask.getUiHandler().post(new Runnable(){

            public void run() {
                UiAsyncTask.this.onPreExecute();
                UiAsyncTask.this.mBackgroundThreadHandler.post((Runnable)new BackgroundTaskRunnable(ParamsArray));
            }
        });
    }

    public final boolean cancel(boolean bl) {
        this.mCancelled = true;
        return this.mCancelled;
    }

    public final boolean isCancelled() {
        return this.mCancelled;
    }

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result Result) {
    }

    protected void onCancelled() {
    }

    protected abstract Result doInBackground(Params ... var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BackgroundTaskRunnable
    implements Runnable {
        private Params[] mParams;

        public BackgroundTaskRunnable(Params ... ParamsArray) {
            this.mParams = ParamsArray;
        }

        @Override
        public void run() {
            final Object Result = UiAsyncTask.this.doInBackground(this.mParams);
            UiAsyncTask.getUiHandler().post(new Runnable(){

                public void run() {
                    if (UiAsyncTask.this.mCancelled) {
                        UiAsyncTask.this.onCancelled();
                    } else {
                        UiAsyncTask.this.onPostExecute(Result);
                    }
                }
            });
        }
    }
}

