/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.announcements;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import org.mozilla.gecko.background.BackgroundService;
import org.mozilla.gecko.background.announcements.AnnouncementsConstants;
import org.mozilla.gecko.background.announcements.AnnouncementsService;
import org.mozilla.gecko.background.common.GlobalConstants;
import org.mozilla.gecko.background.common.log.Logger;

public class AnnouncementsBroadcastService
extends BackgroundService {
    private static final String WORKER_THREAD_NAME = "AnnouncementsBroadcastServiceWorker";
    private static final String LOG_TAG = "AnnounceBrSvc";

    public AnnouncementsBroadcastService() {
        super(WORKER_THREAD_NAME);
    }

    protected static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences("background", 0);
    }

    protected SharedPreferences getSharedPreferences() {
        return this.getSharedPreferences("background", 0);
    }

    private void toggleAlarm(Context context, boolean bl) {
        Class<AnnouncementsService> clazz = AnnouncementsService.class;
        Logger.info(LOG_TAG, (bl ? "R" : "Unr") + "egistering " + clazz.getSimpleName() + ".");
        Intent intent = new Intent(context, clazz);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x10000000);
        if (!bl) {
            this.cancelAlarm(pendingIntent);
            return;
        }
        long l = AnnouncementsBroadcastService.getPollInterval(context);
        this.scheduleAlarm(l, pendingIntent);
    }

    public static void recordLastLaunch(Context context) {
        long l = System.currentTimeMillis();
        SharedPreferences sharedPreferences = AnnouncementsBroadcastService.getSharedPreferences(context);
        long l2 = sharedPreferences.getLong("last_firefox_launch", -1L);
        if (l2 == -1L) {
            Logger.debug(LOG_TAG, "No previous launch recorded.");
        }
        if (l < 1406716645000L) {
            Logger.warn(LOG_TAG, "Current time " + l + " is older than build date " + 1406716645000L + ". Ignoring until clock is corrected.");
            return;
        }
        if (l > AnnouncementsConstants.LATEST_ACCEPTED_LAUNCH_TIMESTAMP_MSEC) {
            Logger.warn(LOG_TAG, "Launch time " + l + " is later than max sane launch timestamp " + AnnouncementsConstants.LATEST_ACCEPTED_LAUNCH_TIMESTAMP_MSEC + ". Ignoring until clock is corrected.");
            return;
        }
        if (l2 > l) {
            Logger.debug(LOG_TAG, "Previous launch " + l2 + " later than current time " + l + ", but new time is sane. Accepting new time.");
        }
        sharedPreferences.edit().putLong("last_firefox_launch", l).commit();
    }

    public static long getPollInterval(Context context) {
        SharedPreferences sharedPreferences = AnnouncementsBroadcastService.getSharedPreferences(context);
        return sharedPreferences.getLong("announce_fetch_interval_msec", AnnouncementsConstants.DEFAULT_ANNOUNCE_FETCH_INTERVAL_MSEC);
    }

    public static void setPollInterval(Context context, long l) {
        SharedPreferences sharedPreferences = AnnouncementsBroadcastService.getSharedPreferences(context);
        sharedPreferences.edit().putLong("announce_fetch_interval_msec", l).commit();
    }

    protected void onHandleIntent(Intent intent) {
        Logger.setThreadLogTag("GeckoAnnounce");
        if (intent == null) {
            Logger.debug(LOG_TAG, "Short-circuiting on null intent.");
            return;
        }
        String string2 = intent.getAction();
        Logger.debug(LOG_TAG, "Broadcast onReceive. Intent is " + string2);
        if ("org.mozilla.fennec.ANNOUNCEMENTS_PREF".equals(string2)) {
            this.handlePrefIntent(intent);
            return;
        }
        if ("android.intent.action.BOOT_COMPLETED".equals(string2) || "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(string2)) {
            BackgroundService.reflectContextToFennec((Context)this, GlobalConstants.GECKO_PREFERENCES_CLASS, GlobalConstants.GECKO_BROADCAST_ANNOUNCEMENTS_PREF_METHOD);
            return;
        }
        Logger.warn(LOG_TAG, "Unknown intent " + string2);
    }

    private void handlePrefIntent(Intent intent) {
        if (!intent.hasExtra("enabled")) {
            Logger.warn(LOG_TAG, "Got ANNOUNCEMENTS_PREF intent without enabled. Ignoring.");
            return;
        }
        boolean bl = intent.getBooleanExtra("enabled", true);
        Logger.debug(LOG_TAG, intent.getStringExtra("branch") + "/" + intent.getStringExtra("pref") + " = " + (intent.hasExtra("enabled") ? Boolean.valueOf(bl) : ""));
        this.toggleAlarm((Context)this, bl);
        if (!bl) {
            Logger.info(LOG_TAG, "!enabled: clearing last fetch.");
            SharedPreferences sharedPreferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove("last_fetch");
            editor.remove("earliest_next_announce_fetch");
            editor.commit();
        }
    }
}

