/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import org.mozilla.gecko.background.healthreport.Environment;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.util.HardwareUtils;

public class AndroidConfigurationProvider
implements EnvironmentBuilder.ConfigurationProvider {
    private static final float MILLIMETERS_PER_INCH = 25.4f;
    private final Configuration configuration;
    private final DisplayMetrics displayMetrics;

    public AndroidConfigurationProvider(Context context) {
        Resources resources = context.getResources();
        this.configuration = resources.getConfiguration();
        this.displayMetrics = resources.getDisplayMetrics();
        HardwareUtils.init((Context)context);
    }

    public boolean hasHardwareKeyboard() {
        return this.configuration.keyboard != 1;
    }

    public Environment.UIType getUIType() {
        if (HardwareUtils.isLargeTablet()) {
            return Environment.UIType.LARGE_TABLET;
        }
        if (HardwareUtils.isSmallTablet()) {
            return Environment.UIType.SMALL_TABLET;
        }
        return Environment.UIType.DEFAULT;
    }

    public int getUIModeType() {
        return this.configuration.uiMode & 0xF;
    }

    public int getScreenLayoutSize() {
        return this.configuration.screenLayout & 0xF;
    }

    public int getScreenXInMM() {
        return Math.round((float)this.displayMetrics.widthPixels / this.displayMetrics.xdpi * 25.4f);
    }

    public int getScreenYInMM() {
        return Math.round((float)this.displayMetrics.heightPixels / this.displayMetrics.ydpi * 25.4f);
    }
}

