/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.distribution;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.SystemClock;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Scanner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.distribution.ReferrerDescriptor;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.ThreadUtils;

@RobocopTarget
public class Distribution {
    private static final String LOGTAG = "GeckoDistribution";
    private static final int STATE_UNKNOWN = 0;
    private static final int STATE_NONE = 1;
    private static final int STATE_SET = 2;
    private static final String FETCH_PROTOCOL = "https";
    private static final String FETCH_HOSTNAME = "distro-download.cdn.mozilla.net";
    private static final String FETCH_PATH = "/android/1/";
    private static final String FETCH_EXTENSION = ".jar";
    private static final String EXPECTED_CONTENT_TYPE = "application/java-archive";
    private static final String DISTRIBUTION_PATH = "distribution/";
    private static final String HISTOGRAM_REFERRER_INVALID = "FENNEC_DISTRIBUTION_REFERRER_INVALID";
    private static final String HISTOGRAM_DOWNLOAD_TIME_MS = "FENNEC_DISTRIBUTION_DOWNLOAD_TIME_MS";
    private static final String HISTOGRAM_CODE_CATEGORY = "FENNEC_DISTRIBUTION_CODE_CATEGORY";
    private static final int CODE_CATEGORY_STATUS_OUT_OF_RANGE = 0;
    private static final int CODE_CATEGORY_OFFLINE = 6;
    private static final int CODE_CATEGORY_FETCH_EXCEPTION = 7;
    private static final int CODE_CATEGORY_POST_FETCH_EXCEPTION = 8;
    private static final int CODE_CATEGORY_POST_FETCH_SECURITY_EXCEPTION = 9;
    private static final int CODE_CATEGORY_MALFORMED_DISTRIBUTION = 10;
    private static final int CODE_CATEGORY_FETCH_SOCKET_ERROR = 11;
    private static final int CODE_CATEGORY_FETCH_SSL_ERROR = 12;
    private static final int CODE_CATEGORY_FETCH_NON_SUCCESS_RESPONSE = 13;
    private static final int CODE_CATEGORY_FETCH_INVALID_CONTENT_TYPE = 14;
    private static final long MAX_DOWNLOAD_TIME_MSEC = 40000L;
    @RobocopTarget
    protected static volatile ReferrerDescriptor referrer;
    private static Distribution instance;
    private final Context context;
    private final String packagePath;
    private final String prefsBranch;
    private volatile int state = 0;
    private File distributionDir;
    private final Queue<Runnable> onDistributionReady = new ConcurrentLinkedQueue<Runnable>();

    public static synchronized Distribution getInstance(Context context) {
        if (instance == null) {
            instance = new Distribution(context);
        }
        return instance;
    }

    private static Distribution init(final Distribution distribution) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                boolean bl = distribution.doInit();
                if (bl) {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Distribution:Set", ""));
                }
            }
        });
        return distribution;
    }

    @RobocopTarget
    public static Distribution init(Context context, String string2, String string3) {
        return Distribution.init(new Distribution(context, string2, string3));
    }

    @RobocopTarget
    public static Distribution init(Context context) {
        return Distribution.init(Distribution.getInstance(context));
    }

    public static JSONArray getBookmarks(Context context) {
        Distribution distribution = new Distribution(context);
        return distribution.getBookmarks();
    }

    public Distribution(Context context, String string2, String string3) {
        this.context = context;
        this.packagePath = string2;
        this.prefsBranch = string3;
    }

    public Distribution(Context context) {
        this(context, context.getPackageResourcePath(), null);
    }

    public static void onReceivedReferrer(ReferrerDescriptor referrerDescriptor) {
        referrer = referrerDescriptor;
    }

    public File getDistributionFile(String string2) {
        Log.d((String)LOGTAG, (String)"Getting file from distribution.");
        if (this.state == 0 && !this.doInit()) {
            return null;
        }
        File file = this.ensureDistributionDir();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, string2);
        if (!file2.exists()) {
            Log.e((String)LOGTAG, (String)("Distribution directory exists, but no file named " + string2));
            return null;
        }
        return file2;
    }

    public DistributionDescriptor getDescriptor() {
        File file = this.getDistributionFile("preferences.json");
        if (file == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.getFileContents(file));
            if (!jSONObject.has("Global")) {
                Log.e((String)LOGTAG, (String)"Distribution preferences.json has no Global entry!");
                return null;
            }
            return new DistributionDescriptor(jSONObject.getJSONObject("Global"));
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting distribution descriptor file.", (Throwable)iOException);
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 10);
            return null;
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error parsing preferences.json", (Throwable)jSONException);
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 10);
            return null;
        }
    }

    public JSONArray getBookmarks() {
        File file = this.getDistributionFile("bookmarks.json");
        if (file == null) {
            return null;
        }
        try {
            return new JSONArray(this.getFileContents(file));
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting bookmarks", (Throwable)iOException);
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 10);
            return null;
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error parsing bookmarks.json", (Throwable)jSONException);
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 10);
            return null;
        }
    }

    @RobocopTarget
    protected boolean doInit() {
        ThreadUtils.assertNotOnUiThread();
        SharedPreferences sharedPreferences = this.prefsBranch == null ? GeckoSharedPrefs.forApp(this.context) : this.context.getSharedPreferences(this.prefsBranch, 0);
        String string2 = this.context.getPackageName() + ".distribution_state";
        this.state = sharedPreferences.getInt(string2, 0);
        if (this.state == 1) {
            this.runReadyQueue();
            return false;
        }
        if (this.state == 2) {
            this.runReadyQueue();
            return true;
        }
        boolean bl = this.checkIntentDistribution() || this.checkAPKDistribution() || this.checkSystemDistribution();
        this.state = bl ? 2 : 1;
        sharedPreferences.edit().putInt(string2, this.state).commit();
        this.runReadyQueue();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIntentDistribution() {
        if (referrer == null) {
            return false;
        }
        URI uRI = this.getReferredDistribution(referrer);
        if (uRI == null) {
            return false;
        }
        long l = SystemClock.uptimeMillis();
        Log.v((String)LOGTAG, (String)("Downloading referred distribution: " + uRI));
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
            httpURLConnection.setRequestProperty("User-Agent", GeckoAppShell.getGeckoInterface().getDefaultUAString());
            httpURLConnection.setRequestProperty("Accept", EXPECTED_CONTENT_TYPE);
            try {
                JarInputStream jarInputStream;
                try {
                    jarInputStream = this.fetchDistribution(uRI, httpURLConnection);
                }
                catch (Exception exception) {
                    Log.e((String)LOGTAG, (String)"Error fetching distribution from network.", (Throwable)exception);
                    Distribution.recordFetchTelemetry(exception);
                    boolean bl = false;
                    httpURLConnection.disconnect();
                    return bl;
                }
                long l2 = SystemClock.uptimeMillis();
                long l3 = l2 - l;
                Log.d((String)LOGTAG, (String)("Distro fetch took " + l3 + "ms; result? " + (jarInputStream != null)));
                Telemetry.HistogramAdd(HISTOGRAM_DOWNLOAD_TIME_MS, Distribution.clamp(40000L, l3));
                if (jarInputStream == null) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    Log.d((String)LOGTAG, (String)"Copying files from fetched zip.");
                    if (!this.copyFilesFromStream(jarInputStream)) return false;
                    this.distributionDir = new File(this.getDataDir(), DISTRIBUTION_PATH);
                    boolean bl = true;
                    return bl;
                }
                catch (SecurityException securityException) {
                    Log.e((String)LOGTAG, (String)"Security exception copying files. Corrupt or malicious?", (Throwable)securityException);
                    Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 9);
                    return false;
                }
                catch (Exception exception) {
                    Log.e((String)LOGTAG, (String)"Error copying files from distribution.", (Throwable)exception);
                    Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 8);
                    return false;
                }
                finally {
                    jarInputStream.close();
                }
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error copying distribution files from network.", (Throwable)iOException);
            Distribution.recordFetchTelemetry(iOException);
        }
        return false;
    }

    private static final int clamp(long l, long l2) {
        return (int)Math.min(l2, l);
    }

    @RobocopTarget
    protected JarInputStream fetchDistribution(URI uRI, HttpURLConnection httpURLConnection) throws IOException {
        int n;
        int n2 = httpURLConnection.getResponseCode();
        Log.d((String)LOGTAG, (String)("Distribution fetch: " + n2));
        if (n2 > 599 || n2 < 100) {
            Log.wtf((String)LOGTAG, (String)("Unexpected HTTP status code: " + n2));
            n = 0;
        } else {
            n = n2 / 100;
        }
        Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, n);
        if (n2 != 200) {
            Log.w((String)LOGTAG, (String)("Got status " + n2 + " fetching distribution."));
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 13);
            return null;
        }
        String string2 = httpURLConnection.getContentType();
        if (string2 == null || !string2.startsWith(EXPECTED_CONTENT_TYPE)) {
            Log.w((String)LOGTAG, (String)"Malformed response: invalid Content-Type.");
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 14);
            return null;
        }
        return new JarInputStream((InputStream)new BufferedInputStream(httpURLConnection.getInputStream()), true);
    }

    private static void recordFetchTelemetry(Exception exception) {
        if (exception == null) {
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 7);
            return;
        }
        if (exception instanceof UnknownHostException) {
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 6);
            return;
        }
        if (exception instanceof SSLException) {
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 12);
            return;
        }
        if (exception instanceof ProtocolException || exception instanceof SocketException) {
            Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 11);
            return;
        }
        Telemetry.HistogramAdd(HISTOGRAM_CODE_CATEGORY, 7);
    }

    private void runReadyQueue() {
        Runnable runnable;
        while ((runnable = this.onDistributionReady.poll()) != null) {
            ThreadUtils.postToBackgroundThread((Runnable)runnable);
        }
    }

    private boolean checkAPKDistribution() {
        try {
            if (this.copyFiles()) {
                this.distributionDir = new File(this.getDataDir(), DISTRIBUTION_PATH);
                return true;
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error copying distribution files from APK.", (Throwable)iOException);
        }
        return false;
    }

    private boolean checkSystemDistribution() {
        File file = this.getSystemDistributionDir();
        if (file.exists()) {
            this.distributionDir = file;
            return true;
        }
        return false;
    }

    private boolean copyFilesFromStream(JarInputStream jarInputStream) throws FileNotFoundException, IOException {
        JarEntry jarEntry;
        byte[] byArray = new byte[1024];
        boolean bl = false;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            File file;
            String string2 = jarEntry.getName();
            if (jarEntry.isDirectory() || !string2.startsWith(DISTRIBUTION_PATH) || (file = this.getDataFile(string2)) == null) continue;
            bl = true;
            this.writeStream(jarInputStream, file, jarEntry.getTime(), byArray);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFiles() throws IOException {
        File file = new File(this.packagePath);
        ZipFile zipFile = new ZipFile(file);
        boolean bl = false;
        try {
            byte[] byArray = new byte[1024];
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                File file2;
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (zipEntry.isDirectory() || !string2.startsWith(DISTRIBUTION_PATH) || (file2 = this.getDataFile(string2)) == null) continue;
                bl = true;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    this.writeStream(inputStream, file2, zipEntry.getTime(), byArray);
                }
                finally {
                    inputStream.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStream(InputStream inputStream, File file, long l, byte[] byArray) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            file.setLastModified(l);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    private File getDataFile(String string2) {
        File file = new File(this.getDataDir(), string2);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            Log.d((String)LOGTAG, (String)("Creating " + file2.getAbsolutePath()));
            if (!file2.mkdirs()) {
                Log.e((String)LOGTAG, (String)("Unable to create directories: " + file2.getAbsolutePath()));
                return null;
            }
        }
        return file;
    }

    private URI getReferredDistribution(ReferrerDescriptor referrerDescriptor) {
        String string2 = referrerDescriptor.content;
        if (string2 == null) {
            return null;
        }
        if (!string2.matches("^[a-zA-Z0-9]+$")) {
            Log.e((String)LOGTAG, (String)("Invalid referrer content: " + string2));
            Telemetry.HistogramAdd(HISTOGRAM_REFERRER_INVALID, 1);
            return null;
        }
        try {
            return new URI(FETCH_PROTOCOL, FETCH_HOSTNAME, FETCH_PATH + string2 + FETCH_EXTENSION, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.wtf((String)LOGTAG, (String)("Invalid URI with content " + string2 + "!"));
            return null;
        }
    }

    private File ensureDistributionDir() {
        if (this.distributionDir != null) {
            return this.distributionDir;
        }
        if (this.state != 2) {
            return null;
        }
        File file = new File(this.getDataDir(), DISTRIBUTION_PATH);
        if (file.exists()) {
            this.distributionDir = file;
            return this.distributionDir;
        }
        File file2 = this.getSystemDistributionDir();
        if (file2.exists()) {
            this.distributionDir = file2;
            return this.distributionDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(File file) throws IOException {
        Scanner scanner = null;
        try {
            scanner = new Scanner(file, "UTF-8");
            String string2 = scanner.useDelimiter("\\A").next();
            return string2;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private String getDataDir() {
        return this.context.getApplicationInfo().dataDir;
    }

    private File getSystemDistributionDir() {
        return new File("/system/" + this.context.getPackageName() + "/distribution");
    }

    public void addOnDistributionReadyCallback(Runnable runnable) {
        if (this.state == 0) {
            this.onDistributionReady.add(runnable);
        } else {
            ThreadUtils.postToBackgroundThread((Runnable)runnable);
        }
    }

    public boolean exists() {
        return this.state == 2;
    }

    @RobocopTarget
    public static class DistributionDescriptor {
        public final boolean valid;
        public final String id;
        public final String version;
        public final String about;
        public final Map<String, String> localizedAbout;

        public DistributionDescriptor(JSONObject jSONObject) {
            this.id = jSONObject.optString("id");
            this.version = jSONObject.optString("version");
            this.about = jSONObject.optString("about");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    if (!string3.startsWith("about.") || jSONObject.isNull(string2 = string3.substring(6))) continue;
                    hashMap.put(string2, jSONObject.getString(string3));
                }
            }
            catch (JSONException jSONException) {
                Log.w((String)Distribution.LOGTAG, (String)"Unable to completely process distribution JSON.", (Throwable)jSONException);
            }
            this.localizedAbout = Collections.unmodifiableMap(hashMap);
            this.valid = null != this.id && null != this.version && null != this.about;
        }
    }
}

