/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.decoders;

import android.graphics.Bitmap;
import android.util.SparseArray;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.decoders.IconDirectoryEntry;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.gfx.BitmapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICODecoder
implements Iterable<Bitmap> {
    public static final int COMPACT_THRESHOLD = 4000;
    public static final int ICO_HEADER_LENGTH_BYTES = 6;
    public static final int ICO_ICONDIRENTRY_LENGTH_BYTES = 16;
    private byte[] decodand;
    private int offset;
    private int len;
    private IconDirectoryEntry[] iconDirectory;
    private boolean isValid;
    private boolean hasDecoded;

    public ICODecoder(byte[] byArray, int n, int n2) {
        this.decodand = byArray;
        this.offset = n;
        this.len = n2;
    }

    private boolean decodeIconDirectoryAndPossiblyPrune() {
        this.hasDecoded = true;
        if (this.offset + this.len > this.decodand.length) {
            return false;
        }
        if (this.len < 6) {
            return false;
        }
        if (this.decodand[this.offset] != 0 || this.decodand[this.offset + 1] != 0 || this.decodand[this.offset + 2] != 1 || this.decodand[this.offset + 3] != 0) {
            return false;
        }
        int n = this.decodand[this.offset + 4] & 0xFF | (this.decodand[this.offset + 5] & 0xFF) << 8;
        if (n <= 0) {
            return false;
        }
        int n2 = 6 + n * 16;
        if (this.len < n2) {
            return false;
        }
        int n3 = this.offset + 6;
        int n4 = Integer.MAX_VALUE;
        SparseArray sparseArray = new SparseArray();
        int n5 = 0;
        while (n5 < n) {
            block15: {
                IconDirectoryEntry iconDirectoryEntry;
                IconDirectoryEntry iconDirectoryEntry2;
                block16: {
                    iconDirectoryEntry2 = IconDirectoryEntry.createFromBuffer(this.decodand, this.offset, this.len, n3);
                    iconDirectoryEntry2.index = n5;
                    if (iconDirectoryEntry2.isErroneous) break block15;
                    if (iconDirectoryEntry2.width <= Favicons.largestFaviconSize) break block16;
                    if (iconDirectoryEntry2.width >= n4) break block15;
                    sparseArray.delete(n4);
                    n4 = iconDirectoryEntry2.width;
                }
                if ((iconDirectoryEntry = (IconDirectoryEntry)sparseArray.get(iconDirectoryEntry2.width)) == null) {
                    sparseArray.put(iconDirectoryEntry2.width, (Object)iconDirectoryEntry2);
                } else if (iconDirectoryEntry.compareTo(iconDirectoryEntry2) < 0) {
                    sparseArray.put(iconDirectoryEntry2.width, (Object)iconDirectoryEntry2);
                }
            }
            ++n5;
            n3 += 16;
        }
        n5 = sparseArray.size();
        if (n5 == 0) {
            return false;
        }
        this.iconDirectory = new IconDirectoryEntry[n5];
        int n6 = 6;
        for (int i = 0; i < n5; ++i) {
            IconDirectoryEntry iconDirectoryEntry = (IconDirectoryEntry)sparseArray.valueAt(i);
            n6 += 16 + iconDirectoryEntry.payloadSize;
            this.iconDirectory[i] = iconDirectoryEntry;
        }
        this.isValid = true;
        this.decodand[this.offset + 4] = (byte)this.iconDirectory.length;
        this.decodand[this.offset + 5] = (byte)(this.iconDirectory.length >>> 8);
        if (this.len - n6 > 4000) {
            this.compactingCopy(n6);
        }
        return true;
    }

    private void compactingCopy(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.decodand, this.offset, byArray, 0, 6);
        int n2 = 6;
        int n3 = 6 + this.iconDirectory.length * 16;
        int n4 = 0;
        for (IconDirectoryEntry iconDirectoryEntry : this.iconDirectory) {
            System.arraycopy(this.decodand, this.offset + iconDirectoryEntry.getOffset(), byArray, n2, 16);
            System.arraycopy(this.decodand, this.offset + iconDirectoryEntry.payloadOffset, byArray, n3, iconDirectoryEntry.payloadSize);
            byArray[n2 + 12] = (byte)n3;
            byArray[n2 + 13] = (byte)(n3 >>> 8);
            byArray[n2 + 14] = (byte)(n3 >>> 16);
            byArray[n2 + 15] = (byte)(n3 >>> 24);
            iconDirectoryEntry.payloadOffset = n3;
            iconDirectoryEntry.index = n4++;
            n3 += iconDirectoryEntry.payloadSize;
            n2 += 16;
        }
        this.decodand = byArray;
        this.offset = 0;
        this.len = n;
    }

    public Bitmap decodeBitmapAtIndex(int n) {
        IconDirectoryEntry iconDirectoryEntry = this.iconDirectory[n];
        if (iconDirectoryEntry.payloadIsPNG) {
            return BitmapUtils.decodeByteArray(this.decodand, this.offset + iconDirectoryEntry.payloadOffset, iconDirectoryEntry.payloadSize);
        }
        byte[] byArray = new byte[22 + iconDirectoryEntry.payloadSize];
        byArray[2] = 1;
        byArray[4] = 1;
        System.arraycopy(this.decodand, this.offset + iconDirectoryEntry.getOffset(), byArray, 6, 16);
        System.arraycopy(this.decodand, this.offset + iconDirectoryEntry.payloadOffset, byArray, 22, iconDirectoryEntry.payloadSize);
        byArray[18] = 22;
        byArray[19] = 0;
        byArray[20] = 0;
        byArray[21] = 0;
        return BitmapUtils.decodeByteArray(byArray);
    }

    public ICOIterator iterator() {
        if (this.hasDecoded && !this.isValid) {
            return null;
        }
        if (!this.hasDecoded && !this.decodeIconDirectoryAndPossiblyPrune()) {
            return null;
        }
        return new ICOIterator();
    }

    public LoadFaviconResult decode() {
        ICOIterator iCOIterator = this.iterator();
        if (iCOIterator == null) {
            return null;
        }
        LoadFaviconResult loadFaviconResult = new LoadFaviconResult();
        loadFaviconResult.bitmapsDecoded = iCOIterator;
        loadFaviconResult.faviconBytes = this.decodand;
        loadFaviconResult.offset = this.offset;
        loadFaviconResult.length = this.len;
        loadFaviconResult.isICO = true;
        return loadFaviconResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ICOIterator
    implements Iterator<Bitmap> {
        private int mIndex;

        private ICOIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < ICODecoder.this.iconDirectory.length;
        }

        @Override
        public Bitmap next() {
            if (this.mIndex > ICODecoder.this.iconDirectory.length) {
                throw new NoSuchElementException("No more elements in this ICO.");
            }
            return ICODecoder.this.decodeBitmapAtIndex(this.mIndex++);
        }

        @Override
        public void remove() {
            if (ICODecoder.this.iconDirectory[this.mIndex] == null) {
                throw new IllegalStateException("Remove already called for element " + this.mIndex);
            }
            ((ICODecoder)ICODecoder.this).iconDirectory[this.mIndex] = null;
        }
    }
}

