/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.res.Resources;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ScrollView;
import android.widget.TextView;
import java.util.HashMap;
import org.mozilla.gecko.R;

class FontSizePreference
extends DialogPreference {
    private static final String LOGTAG = "FontSizePreference";
    private static final int TWIP_TO_PT_RATIO = 20;
    private static final int PREVIEW_FONT_SIZE_UNIT = 3;
    private static final int DEFAULT_FONT_INDEX = 2;
    private final Context mContext;
    private ScrollView mScrollingContainer;
    private TextView mPreviewFontView;
    private Button mIncreaseFontButton;
    private Button mDecreaseFontButton;
    private final String[] mFontTwipValues;
    private final String[] mFontSizeNames;
    private int mSavedFontIndex;
    private int mPreviewFontIndex;
    private final HashMap<String, Integer> mFontTwipToIndexMap;

    public FontSizePreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mPreviewFontIndex = this.mSavedFontIndex = 2;
        this.mContext = context;
        Resources resources = this.mContext.getResources();
        this.mFontTwipValues = resources.getStringArray(R.array.pref_font_size_values);
        this.mFontSizeNames = resources.getStringArray(R.array.pref_font_size_entries);
        this.mFontTwipToIndexMap = new HashMap();
        for (int i = 0; i < this.mFontTwipValues.length; ++i) {
            this.mFontTwipToIndexMap.put(this.mFontTwipValues[i], i);
        }
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View view = layoutInflater.inflate(R.layout.font_size_preference, null);
        this.initInternalViews(view);
        this.updatePreviewFontSize(this.mFontTwipValues[this.mPreviewFontIndex]);
        builder.setTitle(null);
        builder.setView(view);
    }

    private void initInternalViews(View view) {
        this.mScrollingContainer = (ScrollView)view.findViewById(R.id.scrolling_container);
        this.mScrollingContainer.setBackgroundColor(-1);
        this.mPreviewFontView = (TextView)view.findViewById(R.id.preview);
        this.mDecreaseFontButton = (Button)view.findViewById(R.id.decrease_preview_font_button);
        this.mIncreaseFontButton = (Button)view.findViewById(R.id.increase_preview_font_button);
        this.setButtonState(this.mPreviewFontIndex);
        this.mDecreaseFontButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FontSizePreference.this.mPreviewFontIndex = Math.max(FontSizePreference.this.mPreviewFontIndex - 1, 0);
                FontSizePreference.this.updatePreviewFontSize(FontSizePreference.this.mFontTwipValues[FontSizePreference.this.mPreviewFontIndex]);
                FontSizePreference.this.mIncreaseFontButton.setEnabled(true);
                if (FontSizePreference.this.mPreviewFontIndex == 0) {
                    FontSizePreference.this.mDecreaseFontButton.setEnabled(false);
                }
            }
        });
        this.mIncreaseFontButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FontSizePreference.this.mPreviewFontIndex = Math.min(FontSizePreference.this.mPreviewFontIndex + 1, FontSizePreference.this.mFontTwipValues.length - 1);
                FontSizePreference.this.updatePreviewFontSize(FontSizePreference.this.mFontTwipValues[FontSizePreference.this.mPreviewFontIndex]);
                FontSizePreference.this.mDecreaseFontButton.setEnabled(true);
                if (FontSizePreference.this.mPreviewFontIndex == FontSizePreference.this.mFontTwipValues.length - 1) {
                    FontSizePreference.this.mIncreaseFontButton.setEnabled(false);
                }
            }
        });
    }

    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl) {
            this.mPreviewFontIndex = this.mSavedFontIndex;
            return;
        }
        this.mSavedFontIndex = this.mPreviewFontIndex;
        String string2 = this.mFontTwipValues[this.mSavedFontIndex];
        Preference.OnPreferenceChangeListener onPreferenceChangeListener = this.getOnPreferenceChangeListener();
        if (onPreferenceChangeListener == null) {
            Log.e((String)LOGTAG, (String)"PreferenceChangeListener is null. FontSizePreference will not be saved to Gecko.");
            return;
        }
        onPreferenceChangeListener.onPreferenceChange((Preference)this, (Object)string2);
    }

    protected void setSavedFontSize(String string2) {
        Integer n = this.mFontTwipToIndexMap.get(string2);
        if (n != null) {
            this.mPreviewFontIndex = this.mSavedFontIndex = n.intValue();
            return;
        }
        this.resetSavedFontSizeToDefault();
        Log.e((String)LOGTAG, (String)"setSavedFontSize: Given font size does not exist in twip values map. Reverted to default font size.");
    }

    private void updatePreviewFontSize(String string2) {
        float f = this.convertTwipStrToPT(string2);
        if (f == 0.0f) {
            ViewGroup viewGroup = (ViewGroup)this.mScrollingContainer.getParent();
            viewGroup.removeAllViews();
            LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            View view = layoutInflater.inflate(R.layout.font_size_preference, viewGroup);
            this.initInternalViews(view);
            this.mPreviewFontView.setTextSize(3, 1.0f);
        } else {
            this.mPreviewFontView.setTextSize(3, f);
        }
        this.mScrollingContainer.scrollTo(0, 0);
    }

    private void resetSavedFontSizeToDefault() {
        this.mPreviewFontIndex = this.mSavedFontIndex = 2;
    }

    private void setButtonState(int n) {
        if (n == 0) {
            this.mDecreaseFontButton.setEnabled(false);
        } else if (n == this.mFontTwipValues.length - 1) {
            this.mIncreaseFontButton.setEnabled(false);
        }
    }

    protected String getSavedFontSizeName() {
        return this.mFontSizeNames[this.mSavedFontIndex];
    }

    private float convertTwipStrToPT(String string2) {
        return Float.parseFloat(string2) / 20.0f;
    }
}

