/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.preference.PreferenceFragment;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import java.util.Locale;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.preferences.GeckoPreferences;

public class GeckoPreferenceFragment
extends PreferenceFragment {
    private static final String LOGTAG = "GeckoPreferenceFragment";
    private int mPrefsRequestId;
    private Locale lastLocale = Locale.getDefault();

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        Log.d((String)LOGTAG, (String)("onConfigurationChanged: " + configuration.locale));
        Activity activity = this.getActivity();
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        Locale locale = localeManager.onSystemConfigurationChanged((Context)activity, this.getResources(), configuration, this.lastLocale);
        if (locale != null) {
            this.applyLocale(locale);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getPreferenceManager().setSharedPreferencesName("GeckoApp");
        int n = this.getResource();
        if (n == R.xml.preferences_search) {
            this.setHasOptionsMenu(true);
        }
        this.addPreferencesFromResource(n);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        this.setPreferenceScreen(preferenceScreen);
        this.mPrefsRequestId = ((GeckoPreferences)this.getActivity()).setupPreferences((PreferenceGroup)preferenceScreen);
    }

    private String getTitle() {
        int n = this.getResource();
        if (n == R.xml.preferences_locale) {
            return this.getString(R.string.pref_category_language);
        }
        if (n == R.xml.preferences) {
            return this.getString(R.string.settings_title);
        }
        if (n == R.xml.preferences_vendor) {
            return this.getString(R.string.pref_category_vendor);
        }
        return null;
    }

    private void updateTitle() {
        ActionBar actionBar;
        String string2 = this.getTitle();
        if (string2 == null) {
            Log.d((String)LOGTAG, (String)"No new title to show.");
            return;
        }
        PreferenceActivity preferenceActivity = (PreferenceActivity)this.getActivity();
        if (Build.VERSION.SDK_INT >= 11 && preferenceActivity.isMultiPane()) {
            preferenceActivity.showBreadCrumbs((CharSequence)string2, (CharSequence)string2);
            return;
        }
        Log.v((String)LOGTAG, (String)("Setting activity title to " + string2));
        preferenceActivity.setTitle((CharSequence)string2);
        if (Build.VERSION.SDK_INT >= 14 && (actionBar = preferenceActivity.getActionBar()) != null) {
            actionBar.setTitle((CharSequence)string2);
        }
    }

    public void onResume() {
        this.applyLocale(Locale.getDefault());
        super.onResume();
    }

    private void applyLocale(Locale locale) {
        Context context = this.getActivity().getApplicationContext();
        BrowserLocaleManager.getInstance().updateConfiguration(context, locale);
        if (!locale.equals(this.lastLocale)) {
            Log.d((String)LOGTAG, (String)("Locale changed: " + locale));
            this.lastLocale = locale;
            this.getPreferenceScreen().removeAll();
            this.addPreferencesFromResource(this.getResource());
        }
        this.updateTitle();
    }

    private int getResource() {
        int n = 0;
        String string2 = this.getArguments().getString("resource");
        Activity activity = this.getActivity();
        if (string2 != null) {
            Resources resources = activity.getResources();
            String string3 = activity.getPackageName();
            n = resources.getIdentifier(string2, "xml", string3);
        }
        if (n == 0) {
            Log.e((String)LOGTAG, (String)("Failed to find resource: " + string2 + ". Displaying default settings."));
            boolean bl = Build.VERSION.SDK_INT >= 11 && ((PreferenceActivity)activity).isMultiPane();
            n = bl ? R.xml.preferences_customize_tablet : R.xml.preferences;
        }
        return n;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        super.onCreateOptionsMenu(menu2, menuInflater);
        menuInflater.inflate(R.menu.preferences_search_menu, menu2);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPrefsRequestId > 0) {
            PrefsHelper.removeObserver(this.mPrefsRequestId);
        }
    }
}

