/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabspanel;

import android.accounts.Account;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.tabspanel.RemoteTabsList;
import org.mozilla.gecko.tabspanel.TabsPanel;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.GeckoSwipeRefreshLayout;

public class RemoteTabsContainerPanel
extends GeckoSwipeRefreshLayout
implements TabsPanel.PanelView {
    private static final String[] STAGES_TO_SYNC_ON_REFRESH = new String[]{"clients", "tabs"};
    private static final long MINIMUM_REFRESH_INDICATOR_DURATION_IN_MS = 1200L;
    private final Context context;
    private final RemoteTabsSyncObserver syncListener;
    private TabsPanel panel;
    private RemoteTabsList list;
    private boolean isListening;

    public RemoteTabsContainerPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
        this.syncListener = new RemoteTabsSyncObserver();
        this.setOnRefreshListener(new RemoteTabsRefreshListener());
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        this.list = (RemoteTabsList)view;
        this.setColorScheme(R.color.swipe_refresh_orange1, R.color.swipe_refresh_orange2, R.color.swipe_refresh_orange3, R.color.swipe_refresh_orange4);
    }

    public boolean canChildScrollUp() {
        if (FirefoxAccounts.firefoxAccountsExist(this.getContext())) {
            return super.canChildScrollUp();
        }
        return true;
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.panel = tabsPanel;
        this.list.setTabsPanel(tabsPanel);
    }

    public void show() {
        TabsAccessor.getTabs(this.context, this.list);
        Tabs.getInstance().persistAllTabs();
        if (!this.isListening) {
            this.isListening = true;
            FirefoxAccounts.addSyncStatusListener(this.syncListener);
        }
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
        if (this.isListening) {
            this.isListening = false;
            FirefoxAccounts.removeSyncStatusListener(this.syncListener);
        }
    }

    public boolean shouldExpand() {
        return true;
    }

    private class RemoteTabsSyncObserver
    implements FirefoxAccounts.SyncStatusListener {
        protected volatile long lastSyncStarted;

        private RemoteTabsSyncObserver() {
        }

        public Context getContext() {
            return RemoteTabsContainerPanel.this.getContext();
        }

        public Account getAccount() {
            return FirefoxAccounts.getFirefoxAccount(this.getContext());
        }

        public void onSyncStarted() {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                public void run() {
                    RemoteTabsSyncObserver.this.lastSyncStarted = System.currentTimeMillis();
                    RemoteTabsContainerPanel.this.panel.setIconDrawable(TabsPanel.Panel.REMOTE_TABS, R.drawable.tabs_synced_animated);
                    Drawable drawable2 = RemoteTabsContainerPanel.this.panel.getIconDrawable(TabsPanel.Panel.REMOTE_TABS);
                    if (drawable2 instanceof AnimationDrawable) {
                        ((AnimationDrawable)drawable2).start();
                    }
                }
            });
        }

        public void onSyncFinished() {
            Handler handler = ThreadUtils.getUiHandler();
            handler.post(new Runnable(){

                public void run() {
                    TabsAccessor.getTabs(RemoteTabsContainerPanel.this.context, RemoteTabsContainerPanel.this.list);
                }
            });
            long l = this.lastSyncStarted;
            long l2 = System.currentTimeMillis();
            long l3 = Math.max(0L, 1200L - (l2 - l));
            handler.postDelayed(new Runnable(){

                public void run() {
                    RemoteTabsContainerPanel.this.setRefreshing(false);
                    RemoteTabsContainerPanel.this.panel.setIconDrawable(TabsPanel.Panel.REMOTE_TABS, R.drawable.tabs_synced);
                }
            }, l3);
        }
    }

    private class RemoteTabsRefreshListener
    implements GeckoSwipeRefreshLayout.OnRefreshListener {
        private RemoteTabsRefreshListener() {
        }

        public void onRefresh() {
            if (FirefoxAccounts.firefoxAccountsExist(RemoteTabsContainerPanel.this.getContext())) {
                Account account = FirefoxAccounts.getFirefoxAccount(RemoteTabsContainerPanel.this.getContext());
                FirefoxAccounts.requestSync(account, FirefoxAccounts.FORCE, STAGES_TO_SYNC_ON_REFRESH, null);
            }
        }
    }
}

