/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.opengl.GLSurfaceView;
import android.util.Log;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;

public class ViEAndroidGLES20
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    private static String TAG = "WEBRTC-JR";
    private static final boolean DEBUG = false;
    private boolean surfaceCreated;
    private boolean openGLCreated;
    private boolean nativeFunctionsRegisted;
    private ReentrantLock nativeFunctionLock = new ReentrantLock();
    private long nativeObject;
    private int viewWidth;
    private int viewHeight;

    @WebRTCJNITarget
    public static boolean UseOpenGL2(Object object) {
        return ViEAndroidGLES20.class.isInstance(object);
    }

    public ViEAndroidGLES20(Context context) {
        super(context);
        this.init(false, 0, 0);
    }

    @WebRTCJNITarget
    public ViEAndroidGLES20(Context context, boolean bl, int n, int n2) {
        super(context);
        this.init(bl, n, n2);
    }

    private void init(boolean bl, int n, int n2) {
        if (bl) {
            this.getHolder().setFormat(-3);
        }
        this.setEGLContextFactory(new ContextFactory());
        this.setEGLConfigChooser(bl ? new ConfigChooser(8, 8, 8, 8, n, n2) : new ConfigChooser(5, 6, 5, 0, n, n2));
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    private static void checkEglError(String string, EGL10 eGL10) {
        int n;
        while ((n = eGL10.eglGetError()) != 12288) {
            Log.e((String)TAG, (String)String.format("%s: EGL error: 0x%x", string, n));
        }
    }

    public static boolean IsSupported(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        return configurationInfo.reqGlEsVersion >= 131072;
    }

    public void onDrawFrame(GL10 gL10) {
        this.nativeFunctionLock.lock();
        if (!this.nativeFunctionsRegisted || !this.surfaceCreated) {
            this.nativeFunctionLock.unlock();
            return;
        }
        if (!this.openGLCreated) {
            if (0 != this.CreateOpenGLNative(this.nativeObject, this.viewWidth, this.viewHeight)) {
                return;
            }
            this.openGLCreated = true;
        }
        this.DrawNative(this.nativeObject);
        this.nativeFunctionLock.unlock();
    }

    public void onSurfaceChanged(GL10 gL10, int n, int n2) {
        this.surfaceCreated = true;
        this.viewWidth = n;
        this.viewHeight = n2;
        this.nativeFunctionLock.lock();
        if (this.nativeFunctionsRegisted && this.CreateOpenGLNative(this.nativeObject, n, n2) == 0) {
            this.openGLCreated = true;
        }
        this.nativeFunctionLock.unlock();
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
    }

    @WebRTCJNITarget
    public void RegisterNativeObject(long l) {
        this.nativeFunctionLock.lock();
        this.nativeObject = l;
        this.nativeFunctionsRegisted = true;
        this.nativeFunctionLock.unlock();
    }

    @WebRTCJNITarget
    public void DeRegisterNativeObject() {
        this.nativeFunctionLock.lock();
        this.nativeFunctionsRegisted = false;
        this.openGLCreated = false;
        this.nativeObject = 0L;
        this.nativeFunctionLock.unlock();
    }

    @WebRTCJNITarget
    public void ReDraw() {
        if (this.surfaceCreated) {
            this.requestRender();
        }
    }

    private native int CreateOpenGLNative(long var1, int var3, int var4);

    private native void DrawNative(long var1);

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            this.mRedSize = n;
            this.mGreenSize = n2;
            this.mBlueSize = n3;
            this.mAlphaSize = n4;
            this.mDepthSize = n5;
            this.mStencilSize = n6;
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, null, 0, nArray);
            int n = nArray[0];
            if (n <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, eGLConfigArray, n, nArray);
            return this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n < this.mDepthSize || n2 < this.mStencilSize) continue;
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n3 != this.mRedSize || n4 != this.mGreenSize || n5 != this.mBlueSize || n6 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.mValue)) {
                return this.mValue[0];
            }
            return n2;
        }

        private void printConfigs(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            int n = eGLConfigArray.length;
            Log.w((String)TAG, (String)String.format("%d configurations", n));
            for (int i = 0; i < n; ++i) {
                Log.w((String)TAG, (String)String.format("Configuration %d:\n", i));
                this.printConfig(eGL10, eGLDisplay, eGLConfigArray[i]);
            }
        }

        private void printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] stringArray = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] nArray2 = new int[1];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                String string = stringArray[i];
                if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, nArray2)) {
                    Log.w((String)TAG, (String)String.format("  %s: %d\n", string, nArray2[0]));
                    continue;
                }
                while (eGL10.eglGetError() != 12288) {
                }
            }
        }
    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            Log.w((String)TAG, (String)"creating OpenGL ES 2.0 context");
            ViEAndroidGLES20.checkEglError("Before eglCreateContext", eGL10);
            int[] nArray = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray);
            ViEAndroidGLES20.checkEglError("After eglCreateContext", eGL10);
            return eGLContext;
        }

        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            eGL10.eglDestroyContext(eGLDisplay, eGLContext);
        }
    }
}

