/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.home.TwoLinePageRow;

public class RemoteTabsExpandableListAdapter
extends BaseExpandableListAdapter {
    protected final ArrayList<TabsAccessor.RemoteClient> clients;
    protected int groupLayoutId;
    protected int childLayoutId;

    public RemoteTabsExpandableListAdapter(int n, int n2, List<TabsAccessor.RemoteClient> list) {
        this.groupLayoutId = n;
        this.childLayoutId = n2;
        this.clients = new ArrayList();
        if (list != null) {
            this.clients.addAll(list);
        }
    }

    public void replaceClients(List<TabsAccessor.RemoteClient> list) {
        this.clients.clear();
        if (list != null) {
            this.clients.addAll(list);
            this.notifyDataSetChanged();
        } else {
            this.notifyDataSetInvalidated();
        }
    }

    public boolean hasStableIds() {
        return false;
    }

    public long getGroupId(int n) {
        return this.clients.get((int)n).guid.hashCode();
    }

    public int getGroupCount() {
        return this.clients.size();
    }

    public Object getGroup(int n) {
        return this.clients.get(n);
    }

    public int getChildrenCount(int n) {
        return this.clients.get((int)n).tabs.size();
    }

    public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
        ImageView imageView;
        Object object;
        View view2;
        Context context = viewGroup.getContext();
        if (view != null) {
            view2 = view;
        } else {
            object = LayoutInflater.from((Context)context);
            view2 = object.inflate(this.groupLayoutId, viewGroup, false);
        }
        object = this.clients.get(n);
        TextView textView = (TextView)view2.findViewById(R.id.client);
        textView.setText((CharSequence)object.name);
        TextView textView2 = (TextView)view2.findViewById(R.id.last_synced);
        long l = System.currentTimeMillis();
        textView2.setText((CharSequence)TabsAccessor.getLastSyncedString(context, l, object.lastModified));
        ImageView imageView2 = (ImageView)view2.findViewById(R.id.device_type);
        if (imageView2 != null) {
            if ("desktop".equals(object.deviceType)) {
                imageView2.setBackgroundResource(R.drawable.sync_desktop);
            } else {
                imageView2.setBackgroundResource(R.drawable.sync_mobile);
            }
        }
        if ((imageView = (ImageView)view2.findViewById(R.id.device_expanded)) != null) {
            if (object.tabs.isEmpty()) {
                imageView.setBackgroundResource(0);
            } else {
                int n2 = bl ? R.drawable.home_group_expanded : R.drawable.home_group_collapsed;
                imageView.setBackgroundResource(n2);
            }
        }
        return view2;
    }

    public boolean isChildSelectable(int n, int n2) {
        return true;
    }

    public Object getChild(int n, int n2) {
        return this.clients.get((int)n).tabs.get(n2);
    }

    public long getChildId(int n, int n2) {
        return this.clients.get((int)n).tabs.get(n2).hashCode();
    }

    public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
        Object object;
        View view2;
        Context context = viewGroup.getContext();
        if (view != null) {
            view2 = view;
        } else {
            object = LayoutInflater.from((Context)context);
            view2 = object.inflate(this.childLayoutId, viewGroup, false);
        }
        object = this.clients.get(n);
        TabsAccessor.RemoteTab remoteTab = object.tabs.get(n2);
        if (view2 instanceof TwoLinePageRow) {
            ((TwoLinePageRow)view2).update(remoteTab.title, remoteTab.url);
        } else {
            TextView textView = (TextView)view2.findViewById(R.id.title);
            textView.setText((CharSequence)(TextUtils.isEmpty((CharSequence)remoteTab.title) ? remoteTab.url : remoteTab.title));
            TextView textView2 = (TextView)view2.findViewById(R.id.url);
            textView2.setText((CharSequence)remoteTab.url);
        }
        return view2;
    }
}

