/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;

public class RestrictedProfiles {
    private static final String LOGTAG = "GeckoRestrictedProfiles";

    private static String geckoActionToRestriction(int n) {
        for (Restriction restriction : Restriction.values()) {
            if (restriction.id != n) continue;
            return restriction.name;
        }
        throw new IllegalArgumentException("Unknown action " + n);
    }

    private static Bundle getRestrictions() {
        UserManager userManager = (UserManager)GeckoAppShell.getContext().getSystemService("user");
        return userManager.getUserRestrictions();
    }

    @WrapElementForJNI
    public static boolean isUserRestricted() {
        if (GeckoAppShell.getGeckoInterface().getProfile().inGuestMode()) {
            return true;
        }
        if (AppConstants.Versions.preJBMR2) {
            return false;
        }
        return !RestrictedProfiles.getRestrictions().isEmpty();
    }

    public static boolean isAllowed(Restriction restriction) {
        return RestrictedProfiles.isAllowed(restriction.id, null);
    }

    @WrapElementForJNI
    public static boolean isAllowed(int n, String string2) {
        if (GeckoAppShell.getGeckoInterface().getProfile().inGuestMode()) {
            return false;
        }
        if (AppConstants.Versions.preJBMR2) {
            return true;
        }
        try {
            String string3 = RestrictedProfiles.geckoActionToRestriction(n);
            return !RestrictedProfiles.getRestrictions().getBoolean(string3, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.i((String)LOGTAG, (String)"Invalid action", (Throwable)illegalArgumentException);
            return true;
        }
    }

    @WrapElementForJNI
    public static String getUserRestrictions() {
        if (GeckoAppShell.getGeckoInterface().getProfile().inGuestMode()) {
            StringBuilder stringBuilder = new StringBuilder("{ ");
            for (Restriction restriction : Restriction.values()) {
                stringBuilder.append("\"" + restriction.name + "\": true, ");
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
        if (AppConstants.Versions.preJBMR2) {
            return "{}";
        }
        JSONObject jSONObject = new JSONObject();
        Bundle bundle = RestrictedProfiles.getRestrictions();
        Set set = bundle.keySet();
        for (String string2 : set) {
            try {
                jSONObject.put(string2, bundle.get(string2));
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject.toString();
    }

    public static enum Restriction {
        DISALLOW_DOWNLOADS(1, "no_download_files"),
        DISALLOW_INSTALL_EXTENSIONS(2, "no_install_extensions"),
        DISALLOW_INSTALL_APPS(3, "no_install_apps"),
        DISALLOW_BROWSE_FILES(4, "no_browse_files"),
        DISALLOW_SHARE(5, "no_share"),
        DISALLOW_BOOKMARK(6, "no_bookmark"),
        DISALLOW_ADD_CONTACTS(7, "no_add_contacts"),
        DISALLOW_SET_IMAGE(8, "no_set_image");

        public final int id;
        public final String name;

        private Restriction(int n2, String string3) {
            this.id = n2;
            this.name = string3;
        }
    }
}

