/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.TopSitesGridView;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;
import org.mozilla.gecko.widget.ButtonToast;

public abstract class HomeFragment
extends Fragment {
    private static final String LOGTAG = "GeckoHomeFragment";
    protected static final String SHARE_MIME_TYPE = "text/plain";
    static final boolean DEFAULT_CAN_LOAD_HINT = false;
    private boolean mCanLoadHint;
    private boolean mIsLoaded;
    protected HomePager.OnUrlOpenListener mUrlOpenListener;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        this.mCanLoadHint = bundle2 != null ? bundle2.getBoolean("canLoad", false) : false;
        this.mIsLoaded = false;
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (contextMenuInfo == null || !(contextMenuInfo instanceof HomeContextMenuInfo)) {
            return;
        }
        HomeContextMenuInfo homeContextMenuInfo = (HomeContextMenuInfo)contextMenuInfo;
        if (homeContextMenuInfo.isFolder) {
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_contextmenu, (Menu)contextMenu);
        contextMenu.setHeaderTitle((CharSequence)homeContextMenuInfo.getDisplayTitle());
        contextMenu.findItem(R.id.top_sites_edit).setVisible(false);
        contextMenu.findItem(R.id.top_sites_pin).setVisible(false);
        contextMenu.findItem(R.id.top_sites_unpin).setVisible(false);
        if (!homeContextMenuInfo.hasBookmarkId() || homeContextMenuInfo.isInReadingList()) {
            contextMenu.findItem(R.id.home_edit_bookmark).setVisible(false);
        }
        if (!homeContextMenuInfo.canRemove()) {
            contextMenu.findItem(R.id.home_remove).setVisible(false);
        }
        if (!StringUtils.isShareableUrl((String)homeContextMenuInfo.url) || GeckoProfile.get((Context)this.getActivity()).inGuestMode()) {
            contextMenu.findItem(R.id.home_share).setVisible(false);
        }
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (contextMenuInfo == null || !(contextMenuInfo instanceof HomeContextMenuInfo)) {
            return false;
        }
        HomeContextMenuInfo homeContextMenuInfo = (HomeContextMenuInfo)contextMenuInfo;
        FragmentActivity fragmentActivity = this.getActivity();
        int n = menuItem.getItemId();
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, this.getResources().getResourceEntryName(n));
        if (n == R.id.home_copyurl) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't copy address because URL is null");
                return false;
            }
            Clipboard.setText((CharSequence)homeContextMenuInfo.url);
            return true;
        }
        if (n == R.id.home_share) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't share because URL is null");
                return false;
            }
            GeckoAppShell.openUriExternal(homeContextMenuInfo.url, SHARE_MIME_TYPE, "", "", "android.intent.action.SEND", homeContextMenuInfo.getDisplayTitle());
            Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST);
            return true;
        }
        if (n == R.id.home_add_to_launcher) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't add to home screen because URL is null");
                return false;
            }
            Favicons.getPreferredSizeFaviconForPage((Context)fragmentActivity, homeContextMenuInfo.url, new GeckoAppShell.CreateShortcutFaviconLoadedListener(homeContextMenuInfo.url, homeContextMenuInfo.getDisplayTitle()));
            return true;
        }
        if (n == R.id.home_open_private_tab || n == R.id.home_open_new_tab) {
            boolean bl;
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't open in new tab because URL is null");
                return false;
            }
            int n2 = 65;
            boolean bl2 = bl = menuItem.getItemId() == R.id.home_open_private_tab;
            if (bl) {
                n2 |= 4;
            }
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.CONTEXT_MENU);
            String string2 = homeContextMenuInfo.isInReadingList() ? ReaderModeUtils.getAboutReaderForUrl(homeContextMenuInfo.url) : homeContextMenuInfo.url;
            Tab tab = Tabs.getInstance().loadUrl(StringUtils.decodeUserEnteredUrl((String)string2), n2);
            final int n3 = tab.getId();
            String string3 = bl ? this.getResources().getString(R.string.new_private_tab_opened) : this.getResources().getString(R.string.new_tab_opened);
            String string4 = this.getResources().getString(R.string.switch_button_message);
            GeckoApp geckoApp = (GeckoApp)fragmentActivity;
            geckoApp.getButtonToast().show(false, (CharSequence)string3, ButtonToast.LENGTH_SHORT, (CharSequence)string4, R.drawable.switch_button_icon, new ButtonToast.ToastListener(){

                @Override
                public void onButtonClicked() {
                    Tabs.getInstance().selectTab(n3);
                }

                @Override
                public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
                }
            });
            return true;
        }
        if (n == R.id.home_edit_bookmark) {
            new EditBookmarkDialog((Context)fragmentActivity).show(homeContextMenuInfo.url);
            return true;
        }
        if (n == R.id.home_remove) {
            int n4 = homeContextMenuInfo instanceof TopSitesGridView.TopSitesGridContextMenuInfo ? homeContextMenuInfo.position : -1;
            new RemoveItemByUrlTask((Context)fragmentActivity, homeContextMenuInfo.url, homeContextMenuInfo.itemType, n4).execute();
            return true;
        }
        return false;
    }

    public void setUserVisibleHint(boolean bl) {
        if (bl == this.getUserVisibleHint()) {
            return;
        }
        super.setUserVisibleHint(bl);
        this.loadIfVisible();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    void setCanLoadHint(boolean bl) {
        if (this.mCanLoadHint == bl) {
            return;
        }
        this.mCanLoadHint = bl;
        this.loadIfVisible();
    }

    boolean getCanLoadHint() {
        return this.mCanLoadHint;
    }

    protected abstract void load();

    protected boolean canLoad() {
        return this.mCanLoadHint && this.isVisible() && this.getUserVisibleHint();
    }

    protected void loadIfVisible() {
        if (!this.canLoad() || this.mIsLoaded) {
            return;
        }
        this.load();
        this.mIsLoaded = true;
    }

    protected static class RemoveItemByUrlTask
    extends UIAsyncTask.WithoutParams<Void> {
        private final Context mContext;
        private final String mUrl;
        private final HomeContextMenuInfo.RemoveItemType mType;
        private final int mPosition;

        public RemoveItemByUrlTask(Context context, String string2, HomeContextMenuInfo.RemoveItemType removeItemType, int n) {
            super(ThreadUtils.getBackgroundHandler());
            this.mContext = context;
            this.mUrl = string2;
            this.mType = removeItemType;
            this.mPosition = n;
        }

        public Void doInBackground() {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            if (this.mPosition > -1) {
                BrowserDB.unpinSite(contentResolver, this.mPosition);
                if (BrowserDB.hideSuggestedSite(this.mUrl)) {
                    contentResolver.notifyChange(BrowserContract.SuggestedSites.CONTENT_URI, null);
                }
            }
            switch (this.mType) {
                case BOOKMARKS: {
                    BrowserDB.removeBookmarksWithURL(contentResolver, this.mUrl);
                    break;
                }
                case HISTORY: {
                    BrowserDB.removeHistoryEntry(contentResolver, this.mUrl);
                    break;
                }
                case READING_LIST: {
                    BrowserDB.removeReadingListItemWithURL(contentResolver, this.mUrl);
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("url", (Object)this.mUrl);
                        jSONObject.put("notify", false);
                    }
                    catch (JSONException jSONException) {
                        Log.e((String)HomeFragment.LOGTAG, (String)"error building JSON arguments");
                    }
                    GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Reader:Remove", jSONObject.toString());
                    GeckoAppShell.sendEventToGecko(geckoEvent);
                    break;
                }
                default: {
                    Log.e((String)HomeFragment.LOGTAG, (String)("Can't remove item type " + this.mType.toString()));
                }
            }
            return null;
        }

        public void onPostExecute(Void void_) {
            Toast.makeText((Context)this.mContext, (int)R.string.page_removed, (int)0).show();
        }
    }
}

