/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import java.lang.ref.SoftReference;
import java.util.EnumSet;
import java.util.LinkedList;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.ImageLoader;
import org.mozilla.gecko.home.PanelGridView;
import org.mozilla.gecko.home.PanelListView;
import org.mozilla.gecko.home.PanelRefreshLayout;
import org.mozilla.gecko.util.StringUtils;

abstract class PanelLayout
extends FrameLayout {
    private static final String LOGTAG = "GeckoPanelLayout";
    protected final SparseArray<ViewState> mViewStates = new SparseArray();
    private final HomeConfig.PanelConfig mPanelConfig;
    private final DatasetHandler mDatasetHandler;
    private final HomePager.OnUrlOpenListener mUrlOpenListener;
    private final ContextMenuRegistry mContextMenuRegistry;

    public PanelLayout(Context context, HomeConfig.PanelConfig panelConfig, DatasetHandler datasetHandler, HomePager.OnUrlOpenListener onUrlOpenListener, ContextMenuRegistry contextMenuRegistry) {
        super(context);
        this.mPanelConfig = panelConfig;
        this.mDatasetHandler = datasetHandler;
        this.mUrlOpenListener = onUrlOpenListener;
        this.mContextMenuRegistry = contextMenuRegistry;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        int n = this.mViewStates.size();
        for (int i = 0; i < n; ++i) {
            ViewState viewState = (ViewState)this.mViewStates.valueAt(i);
            View view = viewState.getView();
            if (view == null) continue;
            this.maybeSetDataset(view, null);
        }
        this.mViewStates.clear();
    }

    public final void deliverDataset(DatasetRequest datasetRequest, Cursor cursor) {
        View view;
        Log.d((String)LOGTAG, (String)("Delivering request: " + datasetRequest));
        ViewState viewState = (ViewState)this.mViewStates.get(datasetRequest.getViewIndex());
        if (viewState == null) {
            return;
        }
        switch (datasetRequest.getType()) {
            case FILTER_PUSH: {
                viewState.pushFilter(datasetRequest.getFilterDetail());
                break;
            }
            case FILTER_POP: {
                viewState.popFilter();
            }
        }
        View view2 = viewState.getActiveView();
        if (view2 == null) {
            throw new IllegalStateException("No active view for view state: " + viewState.getIndex());
        }
        HomeConfig.ViewConfig viewConfig = viewState.getViewConfig();
        if (cursor == null || cursor.getCount() == 0) {
            view = this.createEmptyView(viewConfig);
            this.maybeSetDataset(view2, null);
        } else {
            view = this.createPanelView(viewConfig);
            this.maybeSetDataset(view, cursor);
        }
        if (view2 != view) {
            this.replacePanelView(view2, view);
        }
    }

    public final void releaseDataset(int n) {
        Log.d((String)LOGTAG, (String)("Releasing dataset: " + n));
        ViewState viewState = (ViewState)this.mViewStates.get(n);
        if (viewState == null) {
            return;
        }
        View view = viewState.getView();
        if (view != null) {
            this.maybeSetDataset(view, null);
        }
    }

    protected final void requestDataset(DatasetRequest datasetRequest) {
        Log.d((String)LOGTAG, (String)("Requesting request: " + datasetRequest));
        if (this.mViewStates.get(datasetRequest.getViewIndex()) == null) {
            return;
        }
        this.mDatasetHandler.requestDataset(datasetRequest);
    }

    protected final void resetDataset(int n) {
        Log.d((String)LOGTAG, (String)("Resetting view with index: " + n));
        if (this.mViewStates.get(n) == null) {
            return;
        }
        this.mDatasetHandler.resetDataset(n);
    }

    protected final View createPanelView(HomeConfig.ViewConfig viewConfig) {
        Object object;
        Log.d((String)LOGTAG, (String)("Creating panel view: " + (Object)((Object)viewConfig.getType())));
        ViewState viewState = (ViewState)this.mViewStates.get(viewConfig.getIndex());
        if (viewState == null) {
            viewState = new ViewState(viewConfig);
            this.mViewStates.put(viewConfig.getIndex(), (Object)viewState);
        }
        if ((object = viewState.getView()) == null) {
            switch (viewConfig.getType()) {
                case LIST: {
                    object = new PanelListView(this.getContext(), viewConfig);
                    break;
                }
                case GRID: {
                    object = new PanelGridView(this.getContext(), viewConfig);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized view type in " + ((Object)((Object)this)).getClass().getSimpleName());
                }
            }
            PanelView panelView = (PanelView)object;
            panelView.setOnItemOpenListener(new PanelOnItemOpenListener(viewState));
            panelView.setOnKeyListener(new PanelKeyListener(viewState));
            panelView.setContextMenuInfoFactory(new HomeContextMenuInfo.Factory(){

                @Override
                public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                    HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                    homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                    homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                    return homeContextMenuInfo;
                }
            });
            this.mContextMenuRegistry.register((View)object);
            if (object instanceof DatasetBacked) {
                DatasetBacked datasetBacked = (DatasetBacked)object;
                datasetBacked.setFilterManager(new PanelFilterManager(viewState));
                if (viewConfig.isRefreshEnabled()) {
                    object = new PanelRefreshLayout(this.getContext(), (View)object, this.mPanelConfig.getId(), viewConfig.getIndex());
                }
            }
            viewState.setView((View)object);
        }
        return object;
    }

    protected final void disposePanelView(View view) {
        Log.d((String)LOGTAG, (String)"Disposing panel view");
        int n = this.mViewStates.size();
        for (int i = 0; i < n; ++i) {
            ViewState viewState = (ViewState)this.mViewStates.valueAt(i);
            if (viewState.getView() != view) continue;
            this.maybeSetDataset(view, null);
            this.mViewStates.remove(viewState.getIndex());
            break;
        }
    }

    private void maybeSetDataset(View view, Cursor cursor) {
        if (view instanceof DatasetBacked) {
            DatasetBacked datasetBacked = (DatasetBacked)view;
            datasetBacked.setDataset(cursor);
        }
    }

    private View createEmptyView(HomeConfig.ViewConfig viewConfig) {
        Log.d((String)LOGTAG, (String)("Creating empty view: " + (Object)((Object)viewConfig.getType())));
        ViewState viewState = (ViewState)this.mViewStates.get(viewConfig.getIndex());
        if (viewState == null) {
            throw new IllegalStateException("No view state found for view index: " + viewConfig.getIndex());
        }
        View view = viewState.getEmptyView();
        if (view == null) {
            view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.home_empty_panel, null);
            HomeConfig.EmptyViewConfig emptyViewConfig = viewConfig.getEmptyViewConfig();
            String string2 = emptyViewConfig == null ? null : emptyViewConfig.getText();
            TextView textView = (TextView)view.findViewById(R.id.home_empty_text);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                textView.setText(R.string.home_default_empty);
            } else {
                textView.setText((CharSequence)string2);
            }
            String string3 = emptyViewConfig == null ? null : emptyViewConfig.getImageUrl();
            ImageView imageView = (ImageView)view.findViewById(R.id.home_empty_image);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                imageView.setImageResource(R.drawable.icon_home_empty_firefox);
            } else {
                ImageLoader.with(this.getContext()).load(string3).error(R.drawable.icon_home_empty_firefox).into(imageView);
            }
            viewState.setEmptyView(view);
        }
        return view;
    }

    private void replacePanelView(View view, View view2) {
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        viewGroup.addView(view2, viewGroup.indexOfChild(view), view.getLayoutParams());
        viewGroup.removeView(view);
    }

    public abstract void load();

    private void pushFilterOnView(ViewState viewState, FilterDetail filterDetail) {
        int n = viewState.getIndex();
        String string2 = viewState.getDatasetId();
        this.mDatasetHandler.requestDataset(new DatasetRequest(n, DatasetRequest.Type.FILTER_PUSH, string2, filterDetail));
    }

    private boolean popFilterOnView(ViewState viewState) {
        if (viewState.canPopFilter()) {
            int n = viewState.getIndex();
            String string2 = viewState.getDatasetId();
            FilterDetail filterDetail = viewState.getPreviousFilter();
            this.mDatasetHandler.requestDataset(new DatasetRequest(n, DatasetRequest.Type.FILTER_POP, string2, filterDetail));
            return true;
        }
        return false;
    }

    private class PanelFilterManager
    implements FilterManager {
        private final ViewState mViewState;

        public PanelFilterManager(ViewState viewState) {
            this.mViewState = viewState;
        }

        @Override
        public FilterDetail getPreviousFilter() {
            return this.mViewState.getPreviousFilter();
        }

        @Override
        public boolean canGoBack() {
            return this.mViewState.canPopFilter();
        }

        @Override
        public void goBack() {
            PanelLayout.this.popFilterOnView(this.mViewState);
        }
    }

    private class PanelKeyListener
    implements View.OnKeyListener {
        private ViewState mViewState;

        public PanelKeyListener(ViewState viewState) {
            this.mViewState = viewState;
        }

        public boolean onKey(View view, int n, KeyEvent keyEvent) {
            if (keyEvent.getAction() == 1 && n == 4) {
                return PanelLayout.this.popFilterOnView(this.mViewState);
            }
            return false;
        }
    }

    private class PanelOnItemOpenListener
    implements OnItemOpenListener {
        private ViewState mViewState;

        public PanelOnItemOpenListener(ViewState viewState) {
            this.mViewState = viewState;
        }

        @Override
        public void onItemOpen(String string2, String string3) {
            if (StringUtils.isFilterUrl((String)string2)) {
                FilterDetail filterDetail = new FilterDetail(StringUtils.getFilterFromUrl((String)string2), string3);
                PanelLayout.this.pushFilterOnView(this.mViewState, filterDetail);
            } else {
                EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet = EnumSet.noneOf(HomePager.OnUrlOpenListener.Flags.class);
                if (this.mViewState.getItemHandler() == HomeConfig.ItemHandler.INTENT) {
                    enumSet.add(HomePager.OnUrlOpenListener.Flags.OPEN_WITH_INTENT);
                }
                PanelLayout.this.mUrlOpenListener.onUrlOpen(string2, enumSet);
            }
        }
    }

    public static interface OnItemOpenListener {
        public void onItemOpen(String var1, String var2);
    }

    static class FilterDetail
    implements Parcelable {
        final String filter;
        final String title;
        public static final Parcelable.Creator<FilterDetail> CREATOR = new Parcelable.Creator<FilterDetail>(){

            public FilterDetail createFromParcel(Parcel parcel) {
                return new FilterDetail(parcel);
            }

            public FilterDetail[] newArray(int n) {
                return new FilterDetail[n];
            }
        };

        private FilterDetail(Parcel parcel) {
            this.filter = parcel.readString();
            this.title = parcel.readString();
        }

        public FilterDetail(String string2, String string3) {
            this.filter = string2;
            this.title = string3;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.filter);
            parcel.writeString(this.title);
        }
    }

    protected class ViewState {
        private final HomeConfig.ViewConfig mViewConfig;
        private SoftReference<View> mView;
        private SoftReference<View> mEmptyView;
        private LinkedList<FilterDetail> mFilterStack;

        public ViewState(HomeConfig.ViewConfig viewConfig) {
            this.mViewConfig = viewConfig;
            this.mView = new SoftReference<Object>(null);
            this.mEmptyView = new SoftReference<Object>(null);
        }

        public HomeConfig.ViewConfig getViewConfig() {
            return this.mViewConfig;
        }

        public int getIndex() {
            return this.mViewConfig.getIndex();
        }

        public View getView() {
            return this.mView.get();
        }

        public void setView(View view) {
            this.mView = new SoftReference<View>(view);
        }

        public View getEmptyView() {
            return this.mEmptyView.get();
        }

        public void setEmptyView(View view) {
            this.mEmptyView = new SoftReference<View>(view);
        }

        public View getActiveView() {
            View view = this.getView();
            if (view != null && view.getParent() != null) {
                return view;
            }
            View view2 = this.getEmptyView();
            if (view2 != null && view2.getParent() != null) {
                return view2;
            }
            return null;
        }

        public String getDatasetId() {
            return this.mViewConfig.getDatasetId();
        }

        public HomeConfig.ItemHandler getItemHandler() {
            return this.mViewConfig.getItemHandler();
        }

        public FilterDetail getCurrentFilter() {
            if (this.mFilterStack == null) {
                return null;
            }
            return this.mFilterStack.peek();
        }

        public FilterDetail getPreviousFilter() {
            if (!this.canPopFilter()) {
                return null;
            }
            return this.mFilterStack.get(1);
        }

        public void pushFilter(FilterDetail filterDetail) {
            if (this.mFilterStack == null) {
                this.mFilterStack = new LinkedList();
                this.mFilterStack.push(new FilterDetail(this.mViewConfig.getFilter(), PanelLayout.this.mPanelConfig.getTitle()));
            }
            this.mFilterStack.push(filterDetail);
        }

        public boolean popFilter() {
            if (!this.canPopFilter()) {
                return false;
            }
            this.mFilterStack.pop();
            return true;
        }

        public boolean canPopFilter() {
            return this.mFilterStack != null && this.mFilterStack.size() > 1;
        }
    }

    public static interface ContextMenuRegistry {
        public void register(View var1);
    }

    public static interface FilterManager {
        public FilterDetail getPreviousFilter();

        public boolean canGoBack();

        public void goBack();
    }

    public static interface PanelView {
        public void setOnItemOpenListener(OnItemOpenListener var1);

        public void setOnKeyListener(View.OnKeyListener var1);

        public void setContextMenuInfoFactory(HomeContextMenuInfo.Factory var1);
    }

    public static interface DatasetHandler {
        public void requestDataset(DatasetRequest var1);

        public void resetDataset(int var1);
    }

    public static class DatasetRequest
    implements Parcelable {
        private final int mViewIndex;
        private final Type mType;
        private final String mDatasetId;
        private final FilterDetail mFilterDetail;
        public static final Parcelable.Creator<DatasetRequest> CREATOR = new Parcelable.Creator<DatasetRequest>(){

            public DatasetRequest createFromParcel(Parcel parcel) {
                return new DatasetRequest(parcel);
            }

            public DatasetRequest[] newArray(int n) {
                return new DatasetRequest[n];
            }
        };

        private DatasetRequest(Parcel parcel) {
            this.mViewIndex = parcel.readInt();
            this.mType = (Type)parcel.readParcelable(this.getClass().getClassLoader());
            this.mDatasetId = parcel.readString();
            this.mFilterDetail = (FilterDetail)parcel.readParcelable(this.getClass().getClassLoader());
        }

        public DatasetRequest(int n, String string2, FilterDetail filterDetail) {
            this(n, Type.DATASET_LOAD, string2, filterDetail);
        }

        public DatasetRequest(int n, Type type, String string2, FilterDetail filterDetail) {
            this.mViewIndex = n;
            this.mType = type;
            this.mDatasetId = string2;
            this.mFilterDetail = filterDetail;
        }

        public int getViewIndex() {
            return this.mViewIndex;
        }

        public Type getType() {
            return this.mType;
        }

        public String getDatasetId() {
            return this.mDatasetId;
        }

        public String getFilter() {
            return this.mFilterDetail != null ? this.mFilterDetail.filter : null;
        }

        public FilterDetail getFilterDetail() {
            return this.mFilterDetail;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mViewIndex);
            parcel.writeParcelable((Parcelable)this.mType, 0);
            parcel.writeString(this.mDatasetId);
            parcel.writeParcelable((Parcelable)this.mFilterDetail, 0);
        }

        public String toString() {
            return "{ index: " + this.mViewIndex + ", type: " + (Object)((Object)this.mType) + ", dataset: " + this.mDatasetId + ", filter: " + this.mFilterDetail + " }";
        }

        public static enum Type implements Parcelable
        {
            DATASET_LOAD,
            FILTER_PUSH,
            FILTER_POP;

            public static final Parcelable.Creator<Type> CREATOR;

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel parcel, int n) {
                parcel.writeInt(this.ordinal());
            }

            static {
                CREATOR = new Parcelable.Creator<Type>(){

                    public Type createFromParcel(Parcel parcel) {
                        return Type.values()[parcel.readInt()];
                    }

                    public Type[] newArray(int n) {
                        return new Type[n];
                    }
                };
            }
        }
    }

    public static interface DatasetBacked {
        public void setDataset(Cursor var1);

        public void setFilterManager(FilterManager var1);
    }
}

