/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.view.animation;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class AnimatorProxy
extends Animation {
    public static final boolean NEEDS_PROXY = Integer.valueOf(Build.VERSION.SDK) < 11;
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private final WeakReference<View> mView;
    private final Camera mCamera = new Camera();
    private boolean mHasPivot;
    private float mAlpha = 1.0f;
    private float mPivotX;
    private float mPivotY;
    private float mRotationX;
    private float mRotationY;
    private float mRotationZ;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTranslationX;
    private float mTranslationY;
    private final RectF mBefore = new RectF();
    private final RectF mAfter = new RectF();
    private final Matrix mTempMatrix = new Matrix();

    public static AnimatorProxy wrap(View view) {
        AnimatorProxy animatorProxy = PROXIES.get(view);
        if (animatorProxy == null || animatorProxy != view.getAnimation()) {
            animatorProxy = new AnimatorProxy(view);
            PROXIES.put(view, animatorProxy);
        }
        return animatorProxy;
    }

    private AnimatorProxy(View view) {
        this.setDuration(0L);
        this.setFillAfter(true);
        view.setAnimation((Animation)this);
        this.mView = new WeakReference<View>(view);
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(float f) {
        if (this.mAlpha != f) {
            this.mAlpha = f;
            View view = (View)this.mView.get();
            if (view != null) {
                view.invalidate();
            }
        }
    }

    public float getPivotX() {
        return this.mPivotX;
    }

    public void setPivotX(float f) {
        if (!this.mHasPivot || this.mPivotX != f) {
            this.prepareForUpdate();
            this.mHasPivot = true;
            this.mPivotX = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getPivotY() {
        return this.mPivotY;
    }

    public void setPivotY(float f) {
        if (!this.mHasPivot || this.mPivotY != f) {
            this.prepareForUpdate();
            this.mHasPivot = true;
            this.mPivotY = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getRotation() {
        return this.mRotationZ;
    }

    public void setRotation(float f) {
        if (this.mRotationZ != f) {
            this.prepareForUpdate();
            this.mRotationZ = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getRotationX() {
        return this.mRotationX;
    }

    public void setRotationX(float f) {
        if (this.mRotationX != f) {
            this.prepareForUpdate();
            this.mRotationX = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getRotationY() {
        return this.mRotationY;
    }

    public void setRotationY(float f) {
        if (this.mRotationY != f) {
            this.prepareForUpdate();
            this.mRotationY = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public void setScaleX(float f) {
        if (this.mScaleX != f) {
            this.prepareForUpdate();
            this.mScaleX = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setScaleY(float f) {
        if (this.mScaleY != f) {
            this.prepareForUpdate();
            this.mScaleY = f;
            this.invalidateAfterUpdate();
        }
    }

    public int getScrollX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollX();
    }

    public void setScrollX(int n) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(n, view.getScrollY());
        }
    }

    public int getScrollY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollY();
    }

    public void setScrollY(int n) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(view.getScrollX(), n);
        }
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public void setTranslationX(float f) {
        if (this.mTranslationX != f) {
            this.prepareForUpdate();
            this.mTranslationX = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public void setTranslationY(float f) {
        if (this.mTranslationY != f) {
            this.prepareForUpdate();
            this.mTranslationY = f;
            this.invalidateAfterUpdate();
        }
    }

    public float getX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getLeft() + this.mTranslationX;
    }

    public void setX(float f) {
        View view = (View)this.mView.get();
        if (view != null) {
            this.setTranslationX(f - (float)view.getLeft());
        }
    }

    public float getY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getTop() + this.mTranslationY;
    }

    public void setY(float f) {
        View view = (View)this.mView.get();
        if (view != null) {
            this.setTranslationY(f - (float)view.getTop());
        }
    }

    private void prepareForUpdate() {
        View view = (View)this.mView.get();
        if (view != null) {
            this.computeRect(this.mBefore, view);
        }
    }

    private void invalidateAfterUpdate() {
        View view = (View)this.mView.get();
        if (view == null || view.getParent() == null) {
            return;
        }
        RectF rectF = this.mAfter;
        this.computeRect(rectF, view);
        rectF.union(this.mBefore);
        ((View)view.getParent()).invalidate((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom));
    }

    private void computeRect(RectF rectF, View view) {
        float f;
        float f2 = view.getWidth();
        float f3 = view.getHeight();
        rectF.set(0.0f, 0.0f, f2, f3);
        Matrix matrix = this.mTempMatrix;
        matrix.reset();
        this.transformMatrix(matrix, view);
        this.mTempMatrix.mapRect(rectF);
        rectF.offset((float)view.getLeft(), (float)view.getTop());
        if (rectF.right < rectF.left) {
            f = rectF.right;
            rectF.right = rectF.left;
            rectF.left = f;
        }
        if (rectF.bottom < rectF.top) {
            f = rectF.top;
            rectF.top = rectF.bottom;
            rectF.bottom = f;
        }
    }

    private void transformMatrix(Matrix matrix, View view) {
        float f = view.getWidth();
        float f2 = view.getHeight();
        boolean bl = this.mHasPivot;
        float f3 = bl ? this.mPivotX : f / 2.0f;
        float f4 = bl ? this.mPivotY : f2 / 2.0f;
        float f5 = this.mRotationX;
        float f6 = this.mRotationY;
        float f7 = this.mRotationZ;
        if (f5 != 0.0f || f6 != 0.0f || f7 != 0.0f) {
            Camera camera = this.mCamera;
            camera.save();
            camera.rotateX(f5);
            camera.rotateY(f6);
            camera.rotateZ(-f7);
            camera.getMatrix(matrix);
            camera.restore();
            matrix.preTranslate(-f3, -f4);
            matrix.postTranslate(f3, f4);
        }
        float f8 = this.mScaleX;
        float f9 = this.mScaleY;
        if (f8 != 1.0f || f9 != 1.0f) {
            matrix.postScale(f8, f9);
            float f10 = -(f3 / f) * (f8 * f - f);
            float f11 = -(f4 / f2) * (f9 * f2 - f2);
            matrix.postTranslate(f10, f11);
        }
        matrix.postTranslate(this.mTranslationX, this.mTranslationY);
    }

    protected void applyTransformation(float f, Transformation transformation) {
        View view = (View)this.mView.get();
        if (view != null) {
            transformation.setAlpha(this.mAlpha);
            this.transformMatrix(transformation.getMatrix(), view);
        }
    }
}

