/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;

public class StringUtils {
    public static byte[] getBytesIso8859_1(String string) {
        return StringUtils.getBytesUnchecked(string, "ISO-8859-1");
    }

    public static byte[] getBytesUsAscii(String string) {
        return StringUtils.getBytesUnchecked(string, "US-ASCII");
    }

    public static byte[] getBytesUtf16(String string) {
        return StringUtils.getBytesUnchecked(string, "UTF-16");
    }

    public static byte[] getBytesUtf16Be(String string) {
        return StringUtils.getBytesUnchecked(string, "UTF-16BE");
    }

    public static byte[] getBytesUtf16Le(String string) {
        return StringUtils.getBytesUnchecked(string, "UTF-16LE");
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytesUnchecked(string, "UTF-8");
    }

    public static byte[] getBytesUnchecked(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.newIllegalStateException(string2, unsupportedEncodingException);
        }
    }

    private static IllegalStateException newIllegalStateException(String string, UnsupportedEncodingException unsupportedEncodingException) {
        return new IllegalStateException(string + ": " + unsupportedEncodingException);
    }

    public static String newString(byte[] byArray, String string) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.newIllegalStateException(string, unsupportedEncodingException);
        }
    }

    public static String newStringIso8859_1(byte[] byArray) {
        return StringUtils.newString(byArray, "ISO-8859-1");
    }

    public static String newStringUsAscii(byte[] byArray) {
        return StringUtils.newString(byArray, "US-ASCII");
    }

    public static String newStringUtf16(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-16");
    }

    public static String newStringUtf16Be(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-16BE");
    }

    public static String newStringUtf16Le(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-16LE");
    }

    public static String newStringUtf8(byte[] byArray) {
        return StringUtils.newString(byArray, "UTF-8");
    }
}

