/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;

final class PicassoDrawable
extends Drawable {
    private static final Paint DEBUG_PAINT = new Paint();
    private static final float FADE_DURATION = 200.0f;
    private final boolean debugging;
    private final float density;
    private final Picasso.LoadedFrom loadedFrom;
    final BitmapDrawable image;
    Drawable placeholder;
    long startTimeMillis;
    boolean animating;
    int alpha = 255;

    static void setBitmap(ImageView imageView, Context context, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean bl, boolean bl2) {
        Drawable drawable = imageView.getDrawable();
        if (drawable instanceof AnimationDrawable) {
            ((AnimationDrawable)drawable).stop();
        }
        PicassoDrawable picassoDrawable = new PicassoDrawable(context, drawable, bitmap, loadedFrom, bl, bl2);
        imageView.setImageDrawable((Drawable)picassoDrawable);
    }

    static void setPlaceholder(ImageView imageView, int n, Drawable drawable) {
        if (n != 0) {
            imageView.setImageResource(n);
        } else {
            imageView.setImageDrawable(drawable);
        }
        if (imageView.getDrawable() instanceof AnimationDrawable) {
            ((AnimationDrawable)imageView.getDrawable()).start();
        }
    }

    PicassoDrawable(Context context, Drawable drawable, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean bl, boolean bl2) {
        boolean bl3;
        Resources resources = context.getResources();
        this.debugging = bl2;
        this.density = resources.getDisplayMetrics().density;
        this.loadedFrom = loadedFrom;
        this.image = new BitmapDrawable(resources, bitmap);
        boolean bl4 = bl3 = loadedFrom != Picasso.LoadedFrom.MEMORY && !bl;
        if (bl3) {
            this.placeholder = drawable;
            this.animating = true;
            this.startTimeMillis = SystemClock.uptimeMillis();
        }
    }

    public void draw(Canvas canvas) {
        if (!this.animating) {
            this.image.draw(canvas);
        } else {
            float f = (float)(SystemClock.uptimeMillis() - this.startTimeMillis) / 200.0f;
            if (f >= 1.0f) {
                this.animating = false;
                this.placeholder = null;
                this.image.draw(canvas);
            } else {
                if (this.placeholder != null) {
                    this.placeholder.draw(canvas);
                }
                int n = (int)((float)this.alpha * f);
                this.image.setAlpha(n);
                this.image.draw(canvas);
                this.image.setAlpha(this.alpha);
                this.invalidateSelf();
            }
        }
        if (this.debugging) {
            this.drawDebugIndicator(canvas);
        }
    }

    public int getIntrinsicWidth() {
        return this.image.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.image.getIntrinsicHeight();
    }

    public void setAlpha(int n) {
        this.alpha = n;
        if (this.placeholder != null) {
            this.placeholder.setAlpha(n);
        }
        this.image.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.placeholder != null) {
            this.placeholder.setColorFilter(colorFilter);
        }
        this.image.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return this.image.getOpacity();
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.image.setBounds(rect);
        if (this.placeholder != null) {
            this.placeholder.setBounds(rect);
        }
    }

    private void drawDebugIndicator(Canvas canvas) {
        DEBUG_PAINT.setColor(-1);
        Path path = PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(16.0f * this.density));
        canvas.drawPath(path, DEBUG_PAINT);
        DEBUG_PAINT.setColor(this.loadedFrom.debugColor);
        path = PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(15.0f * this.density));
        canvas.drawPath(path, DEBUG_PAINT);
    }

    private static Path getTrianglePath(Point point, int n) {
        Point point2 = new Point(point.x + n, point.y);
        Point point3 = new Point(point.x, point.y + n);
        Path path = new Path();
        path.moveTo((float)point.x, (float)point.y);
        path.lineTo((float)point2.x, (float)point2.y);
        path.lineTo((float)point3.x, (float)point3.y);
        return path;
    }
}

