/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.util.SparseBooleanArray;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.TabsAccessor;

public class RemoteClientsDialogFragment
extends DialogFragment {
    private static final String KEY_TITLE = "title";
    private static final String KEY_CHOICE_MODE = "choice_mode";
    private static final String KEY_POSITIVE_BUTTON_TEXT = "positive_button_text";
    private static final String KEY_CLIENTS = "clients";

    public static RemoteClientsDialogFragment newInstance(String string2, String string3, ChoiceMode choiceMode, ArrayList<TabsAccessor.RemoteClient> arrayList) {
        RemoteClientsDialogFragment remoteClientsDialogFragment = new RemoteClientsDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString(KEY_TITLE, string2);
        bundle.putString(KEY_POSITIVE_BUTTON_TEXT, string3);
        bundle.putInt(KEY_CHOICE_MODE, choiceMode.ordinal());
        bundle.putParcelableArrayList(KEY_CLIENTS, arrayList);
        remoteClientsDialogFragment.setArguments(bundle);
        return remoteClientsDialogFragment;
    }

    protected void notifyListener(List<TabsAccessor.RemoteClient> list) {
        RemoteClientsListener remoteClientsListener;
        try {
            remoteClientsListener = (RemoteClientsListener)this.getTargetFragment();
        }
        catch (ClassCastException classCastException) {
            try {
                remoteClientsListener = (RemoteClientsListener)this.getActivity();
            }
            catch (ClassCastException classCastException2) {
                throw new ClassCastException(this.getTargetFragment() + " or " + this.getActivity() + " must implement RemoteClientsListener");
            }
        }
        remoteClientsListener.onClients(list);
    }

    public Dialog onCreateDialog(Bundle bundle) {
        String string2 = this.getArguments().getString(KEY_TITLE);
        String string3 = this.getArguments().getString(KEY_POSITIVE_BUTTON_TEXT);
        ChoiceMode choiceMode = ChoiceMode.values()[this.getArguments().getInt(KEY_CHOICE_MODE)];
        final ArrayList arrayList = this.getArguments().getParcelableArrayList(KEY_CLIENTS);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setTitle((CharSequence)string2);
        CharSequence[] charSequenceArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            charSequenceArray[i] = ((TabsAccessor.RemoteClient)arrayList.get((int)i)).name;
        }
        if (choiceMode == ChoiceMode.MULTIPLE) {
            builder.setMultiChoiceItems(charSequenceArray, null, null);
            builder.setPositiveButton((CharSequence)string3, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    if (n != -1) {
                        return;
                    }
                    AlertDialog alertDialog = (AlertDialog)dialogInterface;
                    SparseBooleanArray sparseBooleanArray = alertDialog.getListView().getCheckedItemPositions();
                    ArrayList<TabsAccessor.RemoteClient> arrayList2 = new ArrayList<TabsAccessor.RemoteClient>();
                    for (int i = 0; i < sparseBooleanArray.size(); ++i) {
                        if (!sparseBooleanArray.get(i)) continue;
                        arrayList2.add((TabsAccessor.RemoteClient)arrayList.get(i));
                    }
                    RemoteClientsDialogFragment.this.notifyListener(arrayList2);
                }
            });
        } else {
            builder.setItems(charSequenceArray, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    ArrayList<TabsAccessor.RemoteClient> arrayList2 = new ArrayList<TabsAccessor.RemoteClient>();
                    arrayList2.add((TabsAccessor.RemoteClient)arrayList.get(n));
                    RemoteClientsDialogFragment.this.notifyListener(arrayList2);
                }
            });
        }
        return builder.create();
    }

    public static enum ChoiceMode {
        SINGLE,
        MULTIPLE;

    }

    public static interface RemoteClientsListener {
        public void onClients(List<TabsAccessor.RemoteClient> var1);
    }
}

