/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SessionParser {
    private static final String LOGTAG = "GeckoSessionParser";

    public abstract void onTabRead(SessionTab var1);

    public void parse(String ... stringArray) {
        LinkedList<SessionTab> linkedList = new LinkedList<SessionTab>();
        int n = 0;
        int n2 = -1;
        try {
            for (String string : stringArray) {
                JSONObject jSONObject = new JSONObject(string).getJSONArray("windows").getJSONObject(0);
                JSONArray jSONArray = jSONObject.getJSONArray("tabs");
                int n3 = jSONObject.optInt("selected", -1);
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    int n4 = jSONObject2.getInt("index");
                    JSONObject jSONObject3 = jSONObject2.getJSONArray("entries").getJSONObject(n4 - 1);
                    String string2 = jSONObject3.getString("url");
                    String string3 = jSONObject3.optString("title");
                    if (string3.length() == 0) {
                        string3 = string2;
                    }
                    ++n;
                    boolean bl = false;
                    if (n3 == i + 1) {
                        bl = true;
                        n2 = n;
                    }
                    linkedList.add(new SessionTab(string3, string2, bl, jSONObject2));
                }
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
            return;
        }
        if (n2 == -1 && linkedList.size() > 0) {
            ((SessionTab)linkedList.getFirst()).mIsSelected = true;
        }
        for (SessionTab sessionTab : linkedList) {
            this.onTabRead(sessionTab);
        }
    }

    public class SessionTab {
        private final String mTitle;
        private final String mUrl;
        private final JSONObject mTabObject;
        private boolean mIsSelected;

        private SessionTab(String string, String string2, boolean bl, JSONObject jSONObject) {
            this.mTitle = string;
            this.mUrl = string2;
            this.mIsSelected = bl;
            this.mTabObject = jSONObject;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public boolean isSelected() {
            return this.mIsSelected;
        }

        public JSONObject getTabObject() {
            return this.mTabObject;
        }
    }
}

