/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.SearchLoader;
import org.mozilla.gecko.home.TwoLinePageRow;
import org.mozilla.gecko.util.StringUtils;

class PinSiteDialog
extends DialogFragment {
    private static final int LOADER_ID_SEARCH = 0;
    private String mSearchTerm;
    private SearchAdapter mAdapter;
    private EditText mSearch;
    private ListView mList;
    private CursorLoaderCallbacks mLoaderCallbacks;
    private OnSiteSelectedListener mOnSiteSelectedListener;

    public static PinSiteDialog newInstance() {
        return new PinSiteDialog();
    }

    private PinSiteDialog() {
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setStyle(1, 16973939);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.pin_site_dialog, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mSearch = (EditText)view.findViewById(R.id.search);
        this.mSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable editable) {
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                PinSiteDialog.this.setSearchTerm(PinSiteDialog.this.mSearch.getText().toString());
                PinSiteDialog.this.filter(PinSiteDialog.this.mSearchTerm);
            }
        });
        this.mSearch.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                if (n != 66 || PinSiteDialog.this.mOnSiteSelectedListener == null) {
                    return false;
                }
                String string2 = PinSiteDialog.this.mSearch.getText().toString().trim();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    String string3 = StringUtils.encodeUserEnteredUrl((String)string2);
                    PinSiteDialog.this.mOnSiteSelectedListener.onSiteSelected(string3, string2);
                    PinSiteDialog.this.dismiss();
                }
                return true;
            }
        });
        this.mSearch.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (bl) {
                    PinSiteDialog.this.getDialog().getWindow().setSoftInputMode(5);
                }
            }
        });
        this.mList = (HomeListView)view.findViewById(R.id.list);
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                if (PinSiteDialog.this.mOnSiteSelectedListener != null) {
                    Cursor cursor = PinSiteDialog.this.mAdapter.getCursor();
                    if (cursor == null || !cursor.moveToPosition(n)) {
                        return;
                    }
                    String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                    String string3 = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                    PinSiteDialog.this.mOnSiteSelectedListener.onSiteSelected(string2, string3);
                }
                PinSiteDialog.this.dismiss();
            }
        });
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        LoaderManager loaderManager = this.getLoaderManager();
        this.mAdapter = new SearchAdapter((Context)this.getActivity());
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mLoaderCallbacks = new CursorLoaderCallbacks();
        loaderManager.initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mLoaderCallbacks);
        if (!TextUtils.isEmpty((CharSequence)this.mSearchTerm)) {
            this.mSearch.setText((CharSequence)this.mSearchTerm);
            this.mSearch.selectAll();
        }
        this.filter("");
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.setOnSiteSelectedListener(null);
    }

    public void setSearchTerm(String string2) {
        this.mSearchTerm = string2;
    }

    private void filter(String string2) {
        SearchLoader.restart(this.getLoaderManager(), 0, this.mLoaderCallbacks, string2, EnumSet.of(BrowserDB.FilterFlags.EXCLUDE_PINNED_SITES));
    }

    public void setOnSiteSelectedListener(OnSiteSelectedListener onSiteSelectedListener) {
        this.mOnSiteSelectedListener = onSiteSelectedListener;
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return SearchLoader.createInstance((Context)PinSiteDialog.this.getActivity(), bundle);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            PinSiteDialog.this.mAdapter.swapCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            PinSiteDialog.this.mAdapter.swapCursor(null);
        }
    }

    private static class SearchAdapter
    extends CursorAdapter {
        private LayoutInflater mInflater;

        public SearchAdapter(Context context) {
            super(context, null, 0);
            this.mInflater = LayoutInflater.from((Context)context);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.setShowIcons(false);
            twoLinePageRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return (TwoLinePageRow)this.mInflater.inflate(R.layout.home_item_row, viewGroup, false);
        }
    }

    public static interface OnSiteSelectedListener {
        public void onSiteSelected(String var1, String var2);
    }
}

