/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import java.util.EnumSet;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.SimpleCursorLoader;

class SearchLoader {
    public static final String LOGTAG = "GeckoSearchLoader";
    private static final String KEY_SEARCH_TERM = "search_term";
    private static final String KEY_FILTER_FLAGS = "flags";

    private SearchLoader() {
    }

    public static Loader<Cursor> createInstance(Context context, Bundle bundle) {
        if (bundle != null) {
            String string2 = bundle.getString(KEY_SEARCH_TERM);
            EnumSet enumSet = (EnumSet)bundle.getSerializable(KEY_FILTER_FLAGS);
            return new SearchCursorLoader(context, string2, enumSet);
        }
        return new SearchCursorLoader(context, "", EnumSet.noneOf(BrowserDB.FilterFlags.class));
    }

    private static Bundle createArgs(String string2, EnumSet<BrowserDB.FilterFlags> enumSet) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_SEARCH_TERM, string2);
        bundle.putSerializable(KEY_FILTER_FLAGS, enumSet);
        return bundle;
    }

    public static void init(LoaderManager loaderManager, int n, LoaderManager.LoaderCallbacks<Cursor> loaderCallbacks, String string2) {
        SearchLoader.init(loaderManager, n, loaderCallbacks, string2, EnumSet.noneOf(BrowserDB.FilterFlags.class));
    }

    public static void init(LoaderManager loaderManager, int n, LoaderManager.LoaderCallbacks<Cursor> loaderCallbacks, String string2, EnumSet<BrowserDB.FilterFlags> enumSet) {
        Bundle bundle = SearchLoader.createArgs(string2, enumSet);
        loaderManager.initLoader(n, bundle, loaderCallbacks);
    }

    public static void restart(LoaderManager loaderManager, int n, LoaderManager.LoaderCallbacks<Cursor> loaderCallbacks, String string2) {
        SearchLoader.restart(loaderManager, n, loaderCallbacks, string2, EnumSet.noneOf(BrowserDB.FilterFlags.class));
    }

    public static void restart(LoaderManager loaderManager, int n, LoaderManager.LoaderCallbacks<Cursor> loaderCallbacks, String string2, EnumSet<BrowserDB.FilterFlags> enumSet) {
        Bundle bundle = SearchLoader.createArgs(string2, enumSet);
        loaderManager.restartLoader(n, bundle, loaderCallbacks);
    }

    public static class SearchCursorLoader
    extends SimpleCursorLoader {
        private static final String TELEMETRY_HISTOGRAM_LOAD_CURSOR = "FENNEC_SEARCH_LOADER_TIME_MS";
        private static final int SEARCH_LIMIT = 100;
        private final String mSearchTerm;
        private final EnumSet<BrowserDB.FilterFlags> mFlags;

        public SearchCursorLoader(Context context, String string2, EnumSet<BrowserDB.FilterFlags> enumSet) {
            super(context);
            this.mSearchTerm = string2;
            this.mFlags = enumSet;
        }

        @Override
        public Cursor loadCursor() {
            long l = SystemClock.uptimeMillis();
            Cursor cursor = BrowserDB.filter(this.getContext().getContentResolver(), this.mSearchTerm, 100, this.mFlags);
            long l2 = SystemClock.uptimeMillis();
            long l3 = l2 - l;
            Telemetry.HistogramAdd(TELEMETRY_HISTOGRAM_LOAD_CURSOR, (int)Math.min(l3, Integer.MAX_VALUE));
            return cursor;
        }

        public String getSearchTerm() {
            return this.mSearchTerm;
        }
    }
}

