/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.tabs.TabsPanel;

class RemoteTabsVerificationPanel
extends ScrollView
implements TabsPanel.PanelView {
    private static final String LOG_TAG = RemoteTabsVerificationPanel.class.getSimpleName();
    private final LinearLayout containingLayout;
    private TabsPanel tabsPanel;

    public RemoteTabsVerificationPanel(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.remote_tabs_verification_panel, (ViewGroup)this);
        this.containingLayout = (LinearLayout)this.findViewById(R.id.remote_tabs_verification_containing_layout);
        View view = this.containingLayout.findViewById(R.id.remote_tabs_confirm_resend);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                State state = FirefoxAccounts.getFirefoxAccountState(RemoteTabsVerificationPanel.this.getContext());
                State.Action action = state.getNeededAction();
                if (state.getNeededAction() != State.Action.NeedsVerification) {
                    RemoteTabsVerificationPanel.this.autoHideTabsPanelOnUnexpectedState("Account expected to need verification on resend, but action was " + (Object)((Object)action) + " instead.");
                    return;
                }
                if (!FirefoxAccounts.resendVerificationEmail(RemoteTabsVerificationPanel.this.getContext())) {
                    RemoteTabsVerificationPanel.this.autoHideTabsPanelOnUnexpectedState("Account DNE when resending verification email.");
                    return;
                }
            }
        });
    }

    private void refresh() {
        TextView textView = (TextView)this.containingLayout.findViewById(R.id.remote_tabs_confirm_verification);
        String string2 = FirefoxAccounts.getFirefoxAccountEmail(this.getContext());
        if (string2 == null) {
            this.autoHideTabsPanelOnUnexpectedState("Account email DNE on View refresh.");
            return;
        }
        String string3 = this.getResources().getString(R.string.fxaccount_confirm_account_verification_link, new Object[]{string2});
        textView.setText((CharSequence)string3);
    }

    private void autoHideTabsPanelOnUnexpectedState(String string2) {
        Log.w((String)LOG_TAG, (String)("Unexpected state: " + string2 + " Closing the tabs panel."));
        if (this.tabsPanel != null) {
            this.tabsPanel.autoHidePanel();
        }
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
    }

    @Override
    public void show() {
        this.refresh();
        this.setVisibility(0);
    }

    @Override
    public void hide() {
        this.setVisibility(8);
    }

    @Override
    public boolean shouldExpand() {
        return this.containingLayout.getOrientation() == 1;
    }
}

