/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.tabs.TabsLayoutItemView;

public class TabsLayoutAdapter
extends BaseAdapter {
    private Context mContext;
    private ArrayList<Tab> mTabs;
    private LayoutInflater mInflater;

    public TabsLayoutAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
    }

    final void setTabs(ArrayList<Tab> arrayList) {
        this.mTabs = arrayList;
        this.notifyDataSetChanged();
    }

    final boolean removeTab(Tab tab) {
        boolean bl = this.mTabs.remove(tab);
        if (bl) {
            this.notifyDataSetChanged();
        }
        return bl;
    }

    final void clear() {
        this.mTabs = null;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mTabs == null ? 0 : this.mTabs.size();
    }

    public Tab getItem(int n) {
        return this.mTabs.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    final int getPositionForTab(Tab tab) {
        if (this.mTabs == null || tab == null) {
            return -1;
        }
        return this.mTabs.indexOf(tab);
    }

    public final View getView(int n, View view, ViewGroup viewGroup) {
        View view2 = view == null ? this.newView(n, viewGroup) : view;
        Tab tab = this.mTabs.get(n);
        this.bindView(view2, tab);
        return view2;
    }

    View newView(int n, ViewGroup viewGroup) {
        View view = this.mInflater.inflate(R.layout.tabs_layout_item_view, viewGroup, false);
        TabsLayoutItemView tabsLayoutItemView = new TabsLayoutItemView(view);
        view.setTag((Object)tabsLayoutItemView);
        return view;
    }

    void bindView(View view, Tab tab) {
        TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view.getTag();
        tabsLayoutItemView.assignValues(tab);
    }
}

