/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.toolbar.ShapedButton;

public class ForwardButton
extends ShapedButton {
    private final Path mBorderPath;
    private final Paint mBorderPaint;
    private final float mBorderWidth = this.getResources().getDimension(R.dimen.nav_button_border_width);

    public ForwardButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPath = new Path();
        this.setPrivateMode(false);
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.mBorderPaint.setColor(bl ? -13223104 : -4210753);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mBorderPath.reset();
        this.mBorderPath.moveTo((float)n - this.mBorderWidth, 0.0f);
        this.mBorderPath.lineTo((float)n - this.mBorderWidth, (float)n2);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        canvas.drawPath(this.mBorderPath, this.mBorderPaint);
    }

    @Override
    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.mTheme.getDrawable((View)this);
        if (drawable2 == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_PRESSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_pb));
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav));
        stateListDrawable.addState(PRIVATE_FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_focused_pb));
        stateListDrawable.addState(FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_focused));
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_private));
        stateListDrawable.addState(EMPTY_STATE_SET, drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_nav_button);
    }
}

