/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.webapp.Allocator;
import org.mozilla.gecko.webapp.ApkResources;
import org.mozilla.gecko.webapp.InstallHelper;

public class InstallListener
extends BroadcastReceiver {
    private static String LOGTAG = "GeckoWebappInstallListener";
    private JSONObject mData;
    private String mManifestUrl;
    private boolean mReceived;
    private File mApkFile;

    public InstallListener(String string2, JSONObject jSONObject, File file) {
        this.mData = jSONObject;
        this.mApkFile = file;
        this.mManifestUrl = string2;
        assert (this.mManifestUrl != null);
        assert (this.mApkFile != null && this.mApkFile.exists());
    }

    public boolean isReceived() {
        return this.mReceived;
    }

    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getData().getSchemeSpecificPart();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.i((String)LOGTAG, (String)"No package name defined in intent");
            return;
        }
        ApkResources apkResources = null;
        try {
            apkResources = new ApkResources(context, string2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)LOGTAG, (String)"Can't find package that's just been installed");
            return;
        }
        String string3 = apkResources.getManifestUrl();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            Log.i((String)LOGTAG, (String)"No manifest URL present in metadata");
            return;
        }
        if (!this.isCorrectManifest(string3)) {
            Log.i((String)LOGTAG, (String)"Manifest URL is for a different install; ignoring");
            return;
        }
        this.mReceived = true;
        context.unregisterReceiver((BroadcastReceiver)this);
        if (this.mApkFile != null && this.mApkFile.delete()) {
            Log.i((String)LOGTAG, (String)"Downloaded APK file deleted");
        }
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            InstallHelper installHelper = new InstallHelper(context, apkResources, null);
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("request", (Object)this.mData);
                Allocator allocator = Allocator.getInstance(context);
                int n = allocator.findOrAllocatePackage(string2);
                installHelper.startInstall("webapp" + n, jSONObject);
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Couldn't parse data from mozApps.install()", (Throwable)jSONException);
            }
            catch (IOException iOException) {
                Log.e((String)LOGTAG, (String)"Couldn't install packaged app", (Throwable)iOException);
            }
        }
    }

    public boolean isCorrectManifest(String string2) {
        try {
            String string3 = this.mManifestUrl.split("\\?")[0];
            String string4 = string2.split("\\?")[0];
            return string3.equals(string4);
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)LOGTAG, (String)"One or both of the manifest URLs is null", (Throwable)nullPointerException);
            return false;
        }
    }
}

