/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.content.AsyncQueryHandler;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.TextView;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import org.mozilla.gecko.LocaleAware;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.search.AcceptsSearchQuery;
import org.mozilla.search.PostSearchFragment;
import org.mozilla.search.R;
import org.mozilla.search.SearchPreferenceActivity;
import org.mozilla.search.autocomplete.ClearableEditText;
import org.mozilla.search.autocomplete.SuggestionsFragment;

public class MainActivity
extends LocaleAware.LocaleAwareFragmentActivity
implements AcceptsSearchQuery {
    private static final String KEY_SEARCH_STATE = "search_state";
    private static final String KEY_EDIT_STATE = "edit_state";
    private static final String KEY_QUERY = "query";
    private SearchState searchState = SearchState.PRESEARCH;
    private EditState editState = EditState.WAITING;
    private AsyncQueryHandler queryHandler;
    private ClearableEditText editText;
    private View preSearch;
    private View postSearch;
    private View settingsButton;
    private View suggestions;
    private SuggestionsFragment suggestionsFragment;
    private static final int SUGGESTION_TRANSITION_DURATION = 300;
    private static final Interpolator SUGGESTION_TRANSITION_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private TextView animationText;
    private View animationCard;
    private int cardPaddingX;
    private int cardPaddingY;
    private int textEndY;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.search_activity_main);
        this.queryHandler = new AsyncQueryHandler(this.getContentResolver()){};
        this.editText = (ClearableEditText)this.findViewById(R.id.search_edit_text);
        this.editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MainActivity.this.setEditState(EditState.EDITING);
            }
        });
        this.editText.setTextListener(new ClearableEditText.TextListener(){

            @Override
            public void onChange(String string2) {
                if (MainActivity.this.editState == EditState.EDITING) {
                    MainActivity.this.suggestionsFragment.loadSuggestions(string2);
                }
            }

            @Override
            public void onSubmit(String string2) {
                String string3 = string2.trim();
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    MainActivity.this.onSearch(string3);
                }
            }

            @Override
            public void onFocusChange(boolean bl) {
                MainActivity.this.setEditState(bl ? EditState.EDITING : EditState.WAITING);
            }
        });
        this.preSearch = this.findViewById(R.id.presearch);
        this.postSearch = this.findViewById(R.id.postsearch);
        this.settingsButton = this.findViewById(R.id.settings_button);
        this.settingsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MainActivity.this.startActivity(new Intent((Context)MainActivity.this, SearchPreferenceActivity.class));
            }
        });
        this.suggestions = this.findViewById(R.id.suggestions);
        this.suggestionsFragment = (SuggestionsFragment)this.getSupportFragmentManager().findFragmentById(R.id.suggestions);
        this.animationText = (TextView)this.findViewById(R.id.animation_text);
        this.animationCard = this.findViewById(R.id.animation_card);
        this.cardPaddingX = this.getResources().getDimensionPixelSize(R.dimen.card_background_padding_x);
        this.cardPaddingY = this.getResources().getDimensionPixelSize(R.dimen.card_background_padding_y);
        this.textEndY = this.getResources().getDimensionPixelSize(R.dimen.animation_text_translation_y);
        if (bundle != null) {
            this.setSearchState(SearchState.valueOf(bundle.getString(KEY_SEARCH_STATE)));
            this.setEditState(EditState.valueOf(bundle.getString(KEY_EDIT_STATE)));
            String string2 = bundle.getString(KEY_QUERY);
            this.editText.setText(string2);
            if (this.searchState == SearchState.POSTSEARCH) {
                ((PostSearchFragment)this.getSupportFragmentManager().findFragmentById(R.id.postsearch)).startSearch(string2);
            }
        } else {
            this.setEditState(EditState.EDITING);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.queryHandler = null;
        this.editText = null;
        this.preSearch = null;
        this.postSearch = null;
        this.settingsButton = null;
        this.suggestionsFragment = null;
        this.suggestions = null;
        this.animationText = null;
        this.animationCard = null;
    }

    protected void onStart() {
        super.onStart();
        Telemetry.startUISession((TelemetryContract.Session)TelemetryContract.Session.SEARCH_ACTIVITY);
    }

    protected void onStop() {
        super.onStop();
        Telemetry.stopUISession((TelemetryContract.Session)TelemetryContract.Session.SEARCH_ACTIVITY);
    }

    public void onNewIntent(Intent intent) {
        this.setSearchState(SearchState.PRESEARCH);
        this.setEditState(EditState.EDITING);
        this.editText.setText("");
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putString(KEY_SEARCH_STATE, this.searchState.toString());
        bundle.putString(KEY_EDIT_STATE, this.editState.toString());
        bundle.putString(KEY_QUERY, this.editText.getText());
    }

    @Override
    public void onSuggest(String string2) {
        this.editText.setText(string2);
    }

    @Override
    public void onSearch(String string2) {
        this.onSearch(string2, null);
    }

    @Override
    public void onSearch(String string2, AcceptsSearchQuery.SuggestionAnimation suggestionAnimation) {
        this.storeQuery(string2);
        ((PostSearchFragment)this.getSupportFragmentManager().findFragmentById(R.id.postsearch)).startSearch(string2);
        if (suggestionAnimation != null) {
            this.animateSuggestion(string2, suggestionAnimation);
        } else {
            this.setEditState(EditState.WAITING);
            this.setSearchState(SearchState.POSTSEARCH);
        }
    }

    private void animateSuggestion(final String string2, AcceptsSearchQuery.SuggestionAnimation suggestionAnimation) {
        this.animationText.setText((CharSequence)string2);
        Rect rect = suggestionAnimation.getStartBounds();
        Rect rect2 = new Rect();
        this.animationCard.getGlobalVisibleRect(rect2, null);
        float f = rect.centerY() - rect2.centerY();
        float f2 = (float)(rect.width() - this.cardPaddingX * 2) / (float)rect2.width();
        float f3 = (float)(rect.height() - this.cardPaddingY * 2) / (float)rect2.height();
        this.animationText.setVisibility(0);
        this.animationCard.setVisibility(0);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.animationText, (String)"translationY", (float[])new float[]{rect.top, this.textEndY}), ObjectAnimator.ofFloat((Object)this.animationCard, (String)"translationY", (float[])new float[]{f, 0.0f}), ObjectAnimator.ofFloat((Object)this.animationCard, (String)"alpha", (float[])new float[]{0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)this.animationCard, (String)"scaleX", (float[])new float[]{f2, 1.0f}), ObjectAnimator.ofFloat((Object)this.animationCard, (String)"scaleY", (float[])new float[]{f3, 1.0f})});
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                MainActivity.this.setEditState(EditState.WAITING);
                MainActivity.this.setSearchState(SearchState.POSTSEARCH);
                MainActivity.this.editText.setText(string2);
                MainActivity.this.animationText.clearAnimation();
                MainActivity.this.animationCard.clearAnimation();
                MainActivity.this.animationText.setVisibility(4);
                MainActivity.this.animationCard.setVisibility(4);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        animatorSet.setDuration(300L);
        animatorSet.setInterpolator(SUGGESTION_TRANSITION_INTERPOLATOR);
        animatorSet.start();
    }

    private void setEditState(EditState editState) {
        if (this.editState == editState) {
            return;
        }
        this.editState = editState;
        this.updateSettingsButtonVisibility();
        this.editText.setActive(editState == EditState.EDITING);
        this.suggestions.setVisibility(editState == EditState.EDITING ? 0 : 4);
    }

    private void setSearchState(SearchState searchState) {
        if (this.searchState == searchState) {
            return;
        }
        this.searchState = searchState;
        this.updateSettingsButtonVisibility();
        this.preSearch.setVisibility(searchState == SearchState.PRESEARCH ? 0 : 4);
        this.postSearch.setVisibility(searchState == SearchState.POSTSEARCH ? 0 : 4);
    }

    private void updateSettingsButtonVisibility() {
        if (this.searchState == SearchState.PRESEARCH && this.editState == EditState.WAITING) {
            this.settingsButton.setVisibility(0);
        } else {
            this.settingsButton.setVisibility(4);
        }
    }

    public void onBackPressed() {
        if (this.editState == EditState.EDITING) {
            this.setEditState(EditState.WAITING);
        } else if (this.searchState == SearchState.POSTSEARCH) {
            this.setSearchState(SearchState.PRESEARCH);
        } else {
            super.onBackPressed();
        }
    }

    private void storeQuery(String string2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(KEY_QUERY, string2);
        this.queryHandler.startInsert(0, null, BrowserContract.SearchHistory.CONTENT_URI, contentValues);
    }

    static enum EditState {
        WAITING,
        EDITING;

    }

    static enum SearchState {
        PRESEARCH,
        POSTSEARCH;

    }
}

