/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.search.R;
import org.mozilla.search.providers.SearchEngine;
import org.mozilla.search.providers.SearchEngineManager;

public class PostSearchFragment
extends Fragment {
    private static final String LOG_TAG = "PostSearchFragment";
    private ProgressBar progressBar;
    private SearchEngineManager searchEngineManager;
    private WebView webview;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.search_fragment_post_search, viewGroup, false);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
        this.webview = (WebView)view.findViewById(R.id.webview);
        this.webview.setWebChromeClient((WebChromeClient)new ChromeClient());
        this.webview.setWebViewClient((WebViewClient)new LinkInterceptingClient());
        this.webview.getSettings().setJavaScriptEnabled(true);
        return view;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.webview.setWebChromeClient(null);
        this.webview.setWebViewClient(null);
        this.webview = null;
        this.progressBar = null;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.searchEngineManager = new SearchEngineManager((Context)activity);
    }

    public void onDetach() {
        super.onDetach();
        this.searchEngineManager.destroy();
        this.searchEngineManager = null;
    }

    public void startSearch(final String string) {
        this.searchEngineManager.getEngine(new SearchEngineManager.SearchEngineCallback(){

            @Override
            public void execute(SearchEngine searchEngine) {
                String string2 = searchEngine.resultsUriForQuery(string);
                if (!TextUtils.equals((CharSequence)PostSearchFragment.this.webview.getUrl(), (CharSequence)string2)) {
                    PostSearchFragment.this.webview.loadUrl("about:blank");
                    PostSearchFragment.this.webview.loadUrl(string2);
                }
            }
        });
    }

    private class ChromeClient
    extends WebChromeClient {
        private ChromeClient() {
        }

        public void onReceivedTitle(final WebView webView, String string) {
            PostSearchFragment.this.searchEngineManager.getEngine(new SearchEngineManager.SearchEngineCallback(){

                @Override
                public void execute(SearchEngine searchEngine) {
                    webView.loadUrl(searchEngine.getInjectableJs());
                }
            });
        }

        public void onProgressChanged(WebView webView, int n) {
            if (n < 100) {
                if (PostSearchFragment.this.progressBar.getVisibility() == 4) {
                    PostSearchFragment.this.progressBar.setVisibility(0);
                }
                PostSearchFragment.this.progressBar.setProgress(n);
            } else {
                PostSearchFragment.this.progressBar.setVisibility(4);
            }
        }
    }

    private class LinkInterceptingClient
    extends WebViewClient {
        private LinkInterceptingClient() {
        }

        public void onPageStarted(WebView webView, final String string, Bitmap bitmap) {
            PostSearchFragment.this.searchEngineManager.getEngine(new SearchEngineManager.SearchEngineCallback(){

                @Override
                public void execute(SearchEngine searchEngine) {
                    if (TextUtils.equals((CharSequence)string, (CharSequence)"about:blank") || searchEngine.isSearchResultsPage(string)) {
                        return;
                    }
                    PostSearchFragment.this.webview.stopLoading();
                    Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.LOAD_URL, (TelemetryContract.Method)TelemetryContract.Method.CONTENT, (String)"search-result");
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
                    intent.setData(Uri.parse((String)string));
                    PostSearchFragment.this.startActivity(intent);
                }
            });
        }
    }
}

