/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.SimpleCursorAdapter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.search.AcceptsSearchQuery;
import org.mozilla.search.R;

public class PreSearchFragment
extends Fragment {
    private AcceptsSearchQuery searchListener;
    private SimpleCursorAdapter cursorAdapter;
    private ListView listView;
    private static final String[] PROJECTION = new String[]{"query", "_id"};
    private static final Uri SEARCH_HISTORY_URI = BrowserContract.SearchHistory.CONTENT_URI.buildUpon().appendQueryParameter("limit", String.valueOf(5)).build();
    private static final int LOADER_ID_SEARCH_HISTORY = 1;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof AcceptsSearchQuery)) {
            throw new ClassCastException(activity.toString() + " must implement AcceptsSearchQuery.");
        }
        this.searchListener = (AcceptsSearchQuery)activity;
    }

    public void onDetach() {
        super.onDetach();
        this.searchListener = null;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)new SearchHistoryLoaderCallbacks());
        this.cursorAdapter = new SimpleCursorAdapter((Context)this.getActivity(), R.layout.search_card_history, null, PROJECTION, new int[]{R.id.site_name}, 0);
    }

    public void onDestroy() {
        super.onDestroy();
        this.getLoaderManager().destroyLoader(1);
        this.cursorAdapter.swapCursor(null);
        this.cursorAdapter = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.search_fragment_pre_search, viewGroup, false);
        this.listView = (ListView)view.findViewById(R.id.list_view);
        this.listView.setAdapter((ListAdapter)this.cursorAdapter);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                Cursor cursor = PreSearchFragment.this.cursorAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n)) {
                    return;
                }
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("query"));
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    final Rect rect = new Rect();
                    view.getGlobalVisibleRect(rect);
                    Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.SEARCH, (TelemetryContract.Method)TelemetryContract.Method.HOMESCREEN, (String)"history");
                    PreSearchFragment.this.searchListener.onSearch(string2, new AcceptsSearchQuery.SuggestionAnimation(){

                        @Override
                        public Rect getStartBounds() {
                            return rect;
                        }
                    });
                }
            }
        });
        return view;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.listView.setAdapter(null);
        this.listView = null;
    }

    private class SearchHistoryLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private SearchHistoryLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new CursorLoader((Context)PreSearchFragment.this.getActivity(), SEARCH_HISTORY_URI, PROJECTION, null, null, "date DESC");
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            if (PreSearchFragment.this.cursorAdapter != null) {
                PreSearchFragment.this.cursorAdapter.swapCursor(cursor);
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            if (PreSearchFragment.this.cursorAdapter != null) {
                PreSearchFragment.this.cursorAdapter.swapCursor(null);
            }
        }
    }
}

