/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search.autocomplete;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.search.R;

public class ClearableEditText
extends FrameLayout {
    private EditText editText;
    private ImageButton clearButton;
    private InputMethodManager inputMethodManager;
    private TextListener listener;
    private boolean active;

    public ClearableEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.clearable_edit_text, (ViewGroup)this);
        this.editText = (EditText)this.findViewById(R.id.edit_text);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void afterTextChanged(Editable editable) {
                if (ClearableEditText.this.listener != null) {
                    ClearableEditText.this.listener.onChange(editable.toString());
                }
                ClearableEditText.this.updateClearButtonVisibility();
            }
        });
        this.editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                if (ClearableEditText.this.listener != null && n == 3) {
                    Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.SEARCH, (TelemetryContract.Method)TelemetryContract.Method.ACTIONBAR, (String)"text");
                    ClearableEditText.this.listener.onSubmit(textView.getText().toString());
                    return true;
                }
                return false;
            }
        });
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (ClearableEditText.this.listener != null) {
                    ClearableEditText.this.listener.onFocusChange(bl);
                }
            }
        });
        this.clearButton = (ImageButton)this.findViewById(R.id.clear_button);
        this.clearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ClearableEditText.this.editText.setText((CharSequence)"");
            }
        });
        this.inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
    }

    public void setText(String string2) {
        this.editText.setText((CharSequence)string2);
        this.editText.setSelection(string2.length());
    }

    public String getText() {
        return this.editText.getText().toString();
    }

    public void setActive(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.updateClearButtonVisibility();
        this.editText.setFocusable(bl);
        this.editText.setFocusableInTouchMode(bl);
        int n = bl ? R.drawable.search_icon_active : R.drawable.search_icon_inactive;
        this.editText.setCompoundDrawablesWithIntrinsicBounds(n, 0, 0, 0);
        if (bl) {
            this.editText.requestFocus();
            this.inputMethodManager.showSoftInput((View)this.editText, 1);
        } else {
            this.editText.clearFocus();
            this.inputMethodManager.hideSoftInputFromWindow(this.editText.getWindowToken(), 0);
        }
    }

    private void updateClearButtonVisibility() {
        boolean bl = this.active && this.editText.getText().length() > 0;
        this.clearButton.setVisibility(bl ? 0 : 8);
    }

    public void setTextListener(TextListener textListener) {
        this.listener = textListener;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return !this.active;
    }

    public static interface TextListener {
        public void onChange(String var1);

        public void onSubmit(String var1);

        public void onFocusChange(boolean var1);
    }
}

