/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSContainer;
import org.mozilla.gecko.util.NativeJSObject;

@RobocopTarget
public final class EventDispatcher {
    private static final String LOGTAG = "GeckoEventDispatcher";
    private static final String GUID = "__guid__";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_SUCCESS = "success";
    private static final EventDispatcher INSTANCE = new EventDispatcher();
    private static final int GECKO_NATIVE_EVENTS_COUNT = 0;
    private static final int GECKO_JSON_EVENTS_COUNT = 256;
    private final Map<String, List<NativeEventListener>> mGeckoThreadNativeListeners = new HashMap<String, List<NativeEventListener>>(0);
    private final Map<String, List<GeckoEventListener>> mGeckoThreadJSONListeners = new HashMap<String, List<GeckoEventListener>>(256);

    public static EventDispatcher getInstance() {
        return INSTANCE;
    }

    private EventDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void registerListener(Class<? extends List<T>> clazz, Map<String, List<T>> map, T t, String[] stringArray) {
        try {
            Map<String, List<T>> map2 = map;
            synchronized (map2) {
                for (String string2 : stringArray) {
                    List<T> list = map.get(string2);
                    if (list == null) {
                        list = clazz.newInstance();
                        map.put(string2, list);
                    }
                    if (list.contains(t)) {
                        throw new IllegalStateException("Already registered " + string2);
                    }
                    list.add(t);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Invalid new list type", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Invalid new list type", instantiationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void checkNotRegistered(Map<String, List<T>> map, String[] stringArray) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            for (String string2 : stringArray) {
                if (map.get(string2) == null) continue;
                throw new IllegalStateException("Already registered " + string2 + " under a different type");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void unregisterListener(Map<String, List<T>> map, T t, String[] stringArray) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            for (String string2 : stringArray) {
                List<T> list = map.get(string2);
                if (list != null && list.remove(t)) continue;
                throw new IllegalArgumentException(string2 + " was not registered");
            }
        }
    }

    public void registerGeckoThreadListener(NativeEventListener nativeEventListener, String ... stringArray) {
        this.checkNotRegistered(this.mGeckoThreadJSONListeners, stringArray);
        this.registerListener(CopyOnWriteArrayList.class, this.mGeckoThreadNativeListeners, nativeEventListener, stringArray);
    }

    @Deprecated
    public void registerGeckoThreadListener(GeckoEventListener geckoEventListener, String ... stringArray) {
        this.checkNotRegistered(this.mGeckoThreadNativeListeners, stringArray);
        this.registerListener(CopyOnWriteArrayList.class, this.mGeckoThreadJSONListeners, geckoEventListener, stringArray);
    }

    public void unregisterGeckoThreadListener(NativeEventListener nativeEventListener, String ... stringArray) {
        this.unregisterListener(this.mGeckoThreadNativeListeners, nativeEventListener, stringArray);
    }

    @Deprecated
    public void unregisterGeckoThreadListener(GeckoEventListener geckoEventListener, String ... stringArray) {
        this.unregisterListener(this.mGeckoThreadJSONListeners, geckoEventListener, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(NativeJSContainer nativeJSContainer) {
        List<NativeEventListener> list;
        String string2 = nativeJSContainer.optString("type", null);
        if (string2 == null) {
            Log.e((String)LOGTAG, (String)"JSON message must have a type property");
            return;
        }
        Object object = this.mGeckoThreadNativeListeners;
        synchronized (object) {
            list = this.mGeckoThreadNativeListeners.get(string2);
        }
        object = nativeJSContainer.optString(GUID, null);
        GeckoEventCallback geckoEventCallback = null;
        if (object != null) {
            geckoEventCallback = new GeckoEventCallback((String)object, string2);
        }
        if (list != null) {
            if (list.size() == 0) {
                Log.w((String)LOGTAG, (String)("No listeners for " + string2));
            }
            try {
                for (NativeEventListener nativeEventListener : list) {
                    nativeEventListener.handleMessage(string2, (NativeJSObject)nativeJSContainer, (EventCallback)geckoEventCallback);
                }
            }
            catch (NativeJSObject.InvalidPropertyException invalidPropertyException) {
                Log.e((String)LOGTAG, (String)("Exception occurred while handling " + string2), (Throwable)invalidPropertyException);
            }
            return;
        }
        try {
            this.dispatchEvent(new JSONObject(nativeJSContainer.toString()), geckoEventCallback);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Cannot parse JSON", (Throwable)jSONException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)LOGTAG, (String)"Cannot convert message to JSON", (Throwable)unsupportedOperationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(JSONObject jSONObject, EventCallback eventCallback) {
        try {
            List<GeckoEventListener> list;
            String string2 = jSONObject.getString("type");
            Map<String, List<GeckoEventListener>> map = this.mGeckoThreadJSONListeners;
            synchronized (map) {
                list = this.mGeckoThreadJSONListeners.get(string2);
            }
            if (list == null || list.size() == 0) {
                Log.w((String)LOGTAG, (String)("No listeners for " + string2));
                if (eventCallback != null) {
                    eventCallback.sendError((Object)"No listeners for request");
                }
                return;
            }
            for (GeckoEventListener geckoEventListener : list) {
                geckoEventListener.handleMessage(string2, jSONObject);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("handleGeckoMessage throws " + (Object)((Object)jSONException)), (Throwable)jSONException);
        }
    }

    @Deprecated
    @RobocopTarget
    public static void sendResponse(JSONObject jSONObject, Object object) {
        EventDispatcher.sendResponseHelper(STATUS_SUCCESS, jSONObject, object);
    }

    @Deprecated
    public static void sendError(JSONObject jSONObject, Object object) {
        EventDispatcher.sendResponseHelper(STATUS_ERROR, jSONObject, object);
    }

    @Deprecated
    private static void sendResponseHelper(String string2, JSONObject jSONObject, Object object) {
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(GUID, (Object)jSONObject.getString(GUID));
            jSONObject2.put("status", (Object)string2);
            jSONObject2.put("response", object);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent(jSONObject.getString("type") + ":Response", jSONObject2.toString()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Unable to send response", (Throwable)jSONException);
        }
    }

    private static class GeckoEventCallback
    implements EventCallback {
        private final String guid;
        private final String type;
        private boolean sent;

        public GeckoEventCallback(String string2, String string3) {
            this.guid = string2;
            this.type = string3;
        }

        public void sendSuccess(Object object) {
            this.sendResponse(EventDispatcher.STATUS_SUCCESS, object);
        }

        public void sendError(Object object) {
            this.sendResponse(EventDispatcher.STATUS_ERROR, object);
        }

        private void sendResponse(String string2, Object object) {
            if (this.sent) {
                throw new IllegalStateException("Callback has already been executed for type=" + this.type + ", guid=" + this.guid);
            }
            this.sent = true;
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(EventDispatcher.GUID, (Object)this.guid);
                jSONObject.put("status", (Object)string2);
                jSONObject.put("response", object);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent(this.type + ":Response", jSONObject.toString()));
            }
            catch (JSONException jSONException) {
                Log.e((String)EventDispatcher.LOGTAG, (String)("Unable to send response for: " + this.type), (Throwable)jSONException);
            }
        }
    }
}

