/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.res.Configuration;
import android.util.Log;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;

public class GeckoScreenOrientation {
    private static final String LOGTAG = "GeckoScreenOrientation";
    private static GeckoScreenOrientation sInstance;
    private static final ScreenOrientation DEFAULT_SCREEN_ORIENTATION;
    private static final int DEFAULT_ROTATION = 0;
    private ScreenOrientation mDefaultScreenOrientation;
    private ScreenOrientation mScreenOrientation;
    private boolean mShouldNotify = true;
    private static final String DEFAULT_SCREEN_ORIENTATION_PREF = "app.orientation.default";

    public GeckoScreenOrientation() {
        PrefsHelper.getPref(DEFAULT_SCREEN_ORIENTATION_PREF, new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, String string3) {
                GeckoScreenOrientation.this.mDefaultScreenOrientation = GeckoScreenOrientation.screenOrientationFromArrayString(string3);
                GeckoScreenOrientation.this.setRequestedOrientation(GeckoScreenOrientation.this.mDefaultScreenOrientation);
            }
        });
        this.mDefaultScreenOrientation = DEFAULT_SCREEN_ORIENTATION;
        this.update();
    }

    public static GeckoScreenOrientation getInstance() {
        if (sInstance == null) {
            sInstance = new GeckoScreenOrientation();
        }
        return sInstance;
    }

    public void enableNotifications() {
        this.update();
        this.mShouldNotify = true;
    }

    public void disableNotifications() {
        this.mShouldNotify = false;
    }

    public boolean update() {
        Activity activity = GeckoAppShell.getGeckoInterface().getActivity();
        if (activity == null) {
            return false;
        }
        Configuration configuration = activity.getResources().getConfiguration();
        return this.update(configuration.orientation);
    }

    public boolean update(int n) {
        return this.update(this.getScreenOrientation(n, this.getRotation()));
    }

    public boolean update(ScreenOrientation screenOrientation) {
        if (this.mScreenOrientation == screenOrientation) {
            return false;
        }
        this.mScreenOrientation = screenOrientation;
        Log.d((String)LOGTAG, (String)("updating to new orientation " + (Object)((Object)this.mScreenOrientation)));
        if (this.mShouldNotify) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createScreenOrientationEvent(this.mScreenOrientation.value));
        }
        return true;
    }

    public int getAndroidOrientation() {
        return GeckoScreenOrientation.screenOrientationToAndroidOrientation(this.getScreenOrientation());
    }

    public ScreenOrientation getScreenOrientation() {
        return this.mScreenOrientation;
    }

    public void lock(int n) {
        this.lock(this.getScreenOrientation(n, this.getRotation()));
    }

    public boolean lock(ScreenOrientation screenOrientation) {
        Log.d((String)LOGTAG, (String)("locking to " + (Object)((Object)screenOrientation)));
        this.update(screenOrientation);
        return this.setRequestedOrientation(screenOrientation);
    }

    public boolean unlock() {
        Log.d((String)LOGTAG, (String)"unlocking");
        this.setRequestedOrientation(this.mDefaultScreenOrientation);
        return this.update();
    }

    private boolean setRequestedOrientation(ScreenOrientation screenOrientation) {
        int n = GeckoScreenOrientation.screenOrientationToActivityInfoOrientation(screenOrientation);
        Activity activity = GeckoAppShell.getGeckoInterface().getActivity();
        if (activity == null) {
            Log.w((String)LOGTAG, (String)"setRequestOrientation: failed to get activity");
        }
        if (activity.getRequestedOrientation() == n) {
            return false;
        }
        activity.setRequestedOrientation(n);
        return true;
    }

    private ScreenOrientation getScreenOrientation(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n2 == 0 || n2 == 1;
        if (n == 1) {
            if (bl) {
                return ScreenOrientation.PORTRAIT_PRIMARY;
            }
            return ScreenOrientation.PORTRAIT_SECONDARY;
        }
        if (n == 2) {
            if (bl) {
                return ScreenOrientation.LANDSCAPE_PRIMARY;
            }
            return ScreenOrientation.LANDSCAPE_SECONDARY;
        }
        return ScreenOrientation.NONE;
    }

    private int getRotation() {
        Activity activity = GeckoAppShell.getGeckoInterface().getActivity();
        if (activity == null) {
            Log.w((String)LOGTAG, (String)"getRotation: failed to get activity");
            return 0;
        }
        return activity.getWindowManager().getDefaultDisplay().getRotation();
    }

    public static ScreenOrientation screenOrientationFromArrayString(String string2) {
        List<String> list = Arrays.asList(string2.split(","));
        if (list.size() == 0) {
            Log.w((String)LOGTAG, (String)"screenOrientationFromArrayString: no orientation in string");
            return DEFAULT_SCREEN_ORIENTATION;
        }
        return GeckoScreenOrientation.screenOrientationFromString(list.get(0));
    }

    public static ScreenOrientation screenOrientationFromString(String string2) {
        if ("portrait".equals(string2)) {
            return ScreenOrientation.PORTRAIT_PRIMARY;
        }
        if ("landscape".equals(string2)) {
            return ScreenOrientation.LANDSCAPE_PRIMARY;
        }
        if ("portrait-primary".equals(string2)) {
            return ScreenOrientation.PORTRAIT_PRIMARY;
        }
        if ("portrait-secondary".equals(string2)) {
            return ScreenOrientation.PORTRAIT_SECONDARY;
        }
        if ("landscape-primary".equals(string2)) {
            return ScreenOrientation.LANDSCAPE_PRIMARY;
        }
        if ("landscape-secondary".equals(string2)) {
            return ScreenOrientation.LANDSCAPE_SECONDARY;
        }
        Log.w((String)LOGTAG, (String)"screenOrientationFromString: unknown orientation string");
        return DEFAULT_SCREEN_ORIENTATION;
    }

    public static int screenOrientationToAndroidOrientation(ScreenOrientation screenOrientation) {
        switch (screenOrientation) {
            case PORTRAIT_PRIMARY: 
            case PORTRAIT_SECONDARY: {
                return 1;
            }
            case LANDSCAPE_PRIMARY: 
            case LANDSCAPE_SECONDARY: {
                return 2;
            }
        }
        return 0;
    }

    public static int screenOrientationToActivityInfoOrientation(ScreenOrientation screenOrientation) {
        switch (screenOrientation) {
            case PORTRAIT_PRIMARY: {
                return 1;
            }
            case PORTRAIT_SECONDARY: {
                return 9;
            }
            case LANDSCAPE_PRIMARY: {
                return 0;
            }
            case LANDSCAPE_SECONDARY: {
                return 8;
            }
            case NONE: 
            case DEFAULT: {
                return -1;
            }
        }
        return 5;
    }

    static {
        DEFAULT_SCREEN_ORIENTATION = ScreenOrientation.DEFAULT;
    }

    public static enum ScreenOrientation {
        NONE(0),
        PORTRAIT_PRIMARY(1),
        PORTRAIT_SECONDARY(2),
        LANDSCAPE_PRIMARY(4),
        LANDSCAPE_SECONDARY(8),
        DEFAULT(16);

        public final short value;

        private ScreenOrientation(int n2) {
            this.value = (short)n2;
        }

        public static ScreenOrientation get(short s) {
            switch (s) {
                case 1: {
                    return PORTRAIT_PRIMARY;
                }
                case 2: {
                    return PORTRAIT_SECONDARY;
                }
                case 4: {
                    return LANDSCAPE_PRIMARY;
                }
                case 8: {
                    return LANDSCAPE_SECONDARY;
                }
                case 16: {
                    return DEFAULT;
                }
            }
            return NONE;
        }
    }
}

