/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.SRPConstants;

public class FxAccount10AuthDelegate
implements FxAccountClient10.AuthDelegate {
    protected final BigInteger N;
    protected final BigInteger g;
    protected final int modNLengthBytes;
    protected final String email;
    protected final byte[] stretchedPWBytes;
    protected AuthState internalAuthState = null;

    public FxAccount10AuthDelegate(String string2, byte[] byArray) {
        this.email = string2;
        this.stretchedPWBytes = byArray;
        this.N = SRPConstants._2048.N;
        this.g = SRPConstants._2048.g;
        this.modNLengthBytes = SRPConstants._2048.byteLength;
    }

    protected BigInteger generateSecretValue() {
        return Utils.generateBigIntegerLessThan(this.N);
    }

    @Override
    public JSONObject getAuthStartBody() throws FxAccountClientException {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"email", (Object)FxAccountUtils.bytes(this.email));
            return jSONObject;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FxAccountClientException(unsupportedEncodingException);
        }
    }

    @Override
    public void onAuthStartResponse(ExtendedJSONObject extendedJSONObject) throws FxAccountClientException {
        if (this.internalAuthState != null) {
            throw new FxAccountClientException("auth must not be written before calling onAuthStartResponse");
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            string2 = extendedJSONObject.getString("srpToken");
            if (string2 == null) {
                throw new FxAccountClientMalformedAuthException("srpToken must be a non-null object");
            }
            ExtendedJSONObject extendedJSONObject2 = extendedJSONObject.getObject("srp");
            if (extendedJSONObject2 == null) {
                throw new FxAccountClientMalformedAuthException("srp must be a non-null object");
            }
            string3 = extendedJSONObject2.getString("salt");
            if (string3 == null) {
                throw new FxAccountClientMalformedAuthException("srp.salt must not be null");
            }
            string4 = extendedJSONObject2.getString("B");
            if (string4 == null) {
                throw new FxAccountClientMalformedAuthException("srp.B must not be null");
            }
            ExtendedJSONObject extendedJSONObject3 = extendedJSONObject.getObject("passwordStretching");
            if (extendedJSONObject3 == null) {
                throw new FxAccountClientMalformedAuthException("passwordStretching must be a non-null object");
            }
            string5 = extendedJSONObject3.getString("salt");
            if (string5 == null) {
                throw new FxAccountClientMalformedAuthException("srp.passwordStretching.salt must not be null");
            }
            this.throwIfParametersAreBad(extendedJSONObject3);
            this.internalAuthState = this.authStateFromParameters(string2, string5, string3, string4, this.generateSecretValue());
        }
        catch (FxAccountClientException fxAccountClientException) {
            throw fxAccountClientException;
        }
        catch (Exception exception) {
            throw new FxAccountClientException(exception);
        }
    }

    protected void throwIfParametersAreBad(ExtendedJSONObject extendedJSONObject) throws FxAccountClientMalformedAuthException {
        if (extendedJSONObject == null || extendedJSONObject.size() != 7 || extendedJSONObject.getString("salt") == null || !"PBKDF2/scrypt/PBKDF2/v1".equals(extendedJSONObject.getString("type")) || 20000L != extendedJSONObject.getLong("PBKDF2_rounds_1") || 65536L != extendedJSONObject.getLong("scrypt_N") || 8L != extendedJSONObject.getLong("scrypt_r") || 1L != extendedJSONObject.getLong("scrypt_p") || 20000L != extendedJSONObject.getLong("PBKDF2_rounds_2")) {
            throw new FxAccountClientMalformedAuthException("malformed passwordStretching parameters: '" + extendedJSONObject.toJSONString() + "'.");
        }
    }

    protected AuthState authStateFromParameters(String string2, String string3, String string4, String string5, BigInteger bigInteger) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        AuthState authState = new AuthState();
        authState.srpToken = string2;
        authState.mainSalt = string3;
        authState.srpSalt = string4;
        authState.x = FxAccountUtils.srpVerifierLowercaseX(this.email.getBytes("UTF-8"), this.stretchedPWBytes, Utils.hex2Byte(string4, 32));
        authState.A = this.g.modPow(bigInteger, this.N);
        String string6 = FxAccountUtils.hexModN(authState.A, this.N);
        BigInteger bigInteger2 = new BigInteger(string5, 16);
        byte[] byArray = Utils.hex2Byte(string6, this.modNLengthBytes);
        byte[] byArray2 = Utils.hex2Byte(string5, this.modNLengthBytes);
        byte[] byArray3 = Utils.sha256(Utils.concatAll(byArray, new byte[][]{byArray2}));
        BigInteger bigInteger3 = new BigInteger(Utils.byte2Hex(byArray3, 32), 16);
        int n = (this.N.bitLength() + 7) / 8;
        byte[] byArray4 = Utils.sha256(Utils.concatAll(Utils.hex2Byte(this.N.toString(16), n), new byte[][]{Utils.hex2Byte(this.g.toString(16), n)}));
        BigInteger bigInteger4 = new BigInteger(Utils.byte2Hex(byArray4, 32), 16);
        BigInteger bigInteger5 = bigInteger2.subtract(bigInteger4.multiply(this.g.modPow(authState.x, this.N)).mod(this.N)).mod(this.N);
        BigInteger bigInteger6 = bigInteger.add(bigInteger3.multiply(authState.x));
        BigInteger bigInteger7 = bigInteger5.modPow(bigInteger6, this.N);
        String string7 = FxAccountUtils.hexModN(bigInteger7, this.N);
        byte[] byArray5 = Utils.hex2Byte(string7, this.modNLengthBytes);
        authState.Mbytes = Utils.sha256(Utils.concatAll(byArray, byArray2, byArray5));
        authState.Kbytes = Utils.sha256(byArray5);
        return authState;
    }

    @Override
    public JSONObject getAuthFinishBody() throws FxAccountClientException {
        if (this.internalAuthState == null) {
            throw new FxAccountClientException("auth must be successfully written before calling getAuthFinishBody.");
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"srpToken", (Object)this.internalAuthState.srpToken);
        jSONObject.put((Object)"A", (Object)FxAccountUtils.hexModN(this.internalAuthState.A, this.N));
        jSONObject.put((Object)"M", (Object)Utils.byte2Hex(this.internalAuthState.Mbytes, 32));
        return jSONObject;
    }

    @Override
    public byte[] getSharedBytes() throws FxAccountClientException {
        if (this.internalAuthState == null) {
            throw new FxAccountClientException("auth must be successfully finished before calling getSharedBytes.");
        }
        return this.internalAuthState.Kbytes;
    }

    public static class FxAccountClientMalformedAuthException
    extends FxAccountClientException {
        private static final long serialVersionUID = 3585262174699395505L;

        public FxAccountClientMalformedAuthException(String string2) {
            super(string2);
        }
    }

    protected static class AuthState {
        protected String srpToken;
        protected String mainSalt;
        protected String srpSalt;
        protected BigInteger x;
        protected BigInteger A;
        protected byte[] Kbytes;
        protected byte[] Mbytes;

        protected AuthState() {
        }
    }
}

