/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class PanelInfoManager
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoPanelInfoManager";
    private static AtomicInteger sRequestId = new AtomicInteger(0);
    private static final SparseArray<RequestCallback> sCallbacks = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPanelsById(Set<String> set, RequestCallback requestCallback) {
        int n = sRequestId.getAndIncrement();
        JSONObject jSONObject = sCallbacks;
        synchronized (jSONObject) {
            if (sCallbacks.size() == 0) {
                EventDispatcher.getInstance().registerGeckoThreadListener(this, "HomePanels:Data");
            }
            sCallbacks.put(n, (Object)requestCallback);
        }
        jSONObject = new JSONObject();
        try {
            jSONObject.put("requestId", n);
            if (set != null && set.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (String string2 : set) {
                    jSONArray.put((Object)string2);
                }
                jSONObject.put("ids", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Failed to build event to request panels by id", (Throwable)jSONException);
            return;
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomePanels:Get", jSONObject.toString()));
    }

    public void requestAvailablePanels(RequestCallback requestCallback) {
        this.requestPanelsById(null, requestCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(String string2, JSONObject jSONObject) {
        final ArrayList<PanelInfo> arrayList = new ArrayList<PanelInfo>();
        try {
            RequestCallback requestCallback;
            JSONArray jSONArray = jSONObject.getJSONArray("panels");
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                PanelInfo panelInfo = this.getPanelInfoFromJSON(jSONArray.getJSONObject(i));
                arrayList.add(panelInfo);
            }
            int n2 = jSONObject.getInt("requestId");
            SparseArray<RequestCallback> sparseArray = sCallbacks;
            synchronized (sparseArray) {
                requestCallback = (RequestCallback)sCallbacks.get(n2);
                sCallbacks.delete(n2);
                if (sCallbacks.size() == 0) {
                    EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "HomePanels:Data");
                }
            }
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    requestCallback.onComplete(arrayList);
                }
            });
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Exception handling " + string2 + " message"), (Throwable)jSONException);
        }
    }

    private PanelInfo getPanelInfoFromJSON(JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString("id");
        String string3 = jSONObject.getString("title");
        return new PanelInfo(string2, string3, jSONObject);
    }

    public static interface RequestCallback {
        public void onComplete(List<PanelInfo> var1);
    }

    public class PanelInfo {
        private final String mId;
        private final String mTitle;
        private final JSONObject mJSONData;

        public PanelInfo(String string2, String string3, JSONObject jSONObject) {
            this.mId = string2;
            this.mTitle = string3;
            this.mJSONData = jSONObject;
        }

        public String getId() {
            return this.mId;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public HomeConfig.PanelConfig toPanelConfig() {
            try {
                return new HomeConfig.PanelConfig(this.mJSONData);
            }
            catch (Exception exception) {
                Log.e((String)PanelInfoManager.LOGTAG, (String)"Failed to convert PanelInfo to PanelConfig", (Throwable)exception);
                return null;
            }
        }
    }
}

