/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.accounts.Account;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteTabsExpandableListAdapter;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeExpandableListView;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.widget.GeckoSwipeRefreshLayout;

public class RemoteTabsExpandableListFragment
extends HomeFragment {
    private static final String LOGTAG = "GeckoRemoteTabsExpList";
    private static final int LOADER_ID_REMOTE_TABS = 0;
    private static final String[] STAGES_TO_SYNC_ON_REFRESH = new String[]{"clients", "tabs"};
    private RemoteTabsExpandableListAdapter mAdapter;
    private HomeExpandableListView mList;
    private View mEmptyView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private GeckoSwipeRefreshLayout mRefreshLayout;
    private RemoteTabsSyncListener mSyncStatusListener;

    public static RemoteTabsExpandableListFragment newInstance() {
        return new RemoteTabsExpandableListFragment();
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_remote_tabs_list_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        this.mRefreshLayout = (GeckoSwipeRefreshLayout)view.findViewById(R.id.remote_tabs_refresh_layout);
        this.mRefreshLayout.setColorScheme(R.color.swipe_refresh_orange, R.color.swipe_refresh_white, R.color.swipe_refresh_orange, R.color.swipe_refresh_white);
        this.mRefreshLayout.setOnRefreshListener(new RemoteTabsRefreshListener());
        this.mSyncStatusListener = new RemoteTabsSyncListener();
        FirefoxAccounts.addSyncStatusListener(this.mSyncStatusListener);
        this.mList = (HomeExpandableListView)view.findViewById(R.id.list);
        this.mList.setTag("remote_tabs");
        this.mList.setOnChildClickListener(new ExpandableListView.OnChildClickListener(){

            public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
                ExpandableListAdapter expandableListAdapter = expandableListView.getExpandableListAdapter();
                TabsAccessor.RemoteTab remoteTab = (TabsAccessor.RemoteTab)expandableListAdapter.getChild(n, n2);
                if (remoteTab == null) {
                    return false;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM);
                RemoteTabsExpandableListFragment.this.mUrlOpenListener.onUrlOpen(remoteTab.url, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
                return true;
            }
        });
        this.mList.setOnGroupClickListener(new ExpandableListView.OnGroupClickListener(){

            public boolean onGroupClick(ExpandableListView expandableListView, View view, int n, long l) {
                return true;
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.ExpandableFactory(){

            @Override
            public HomeContextMenuInfo makeInfoForAdapter(View view, int n, long l, ExpandableListAdapter expandableListAdapter) {
                int n2;
                long l2 = RemoteTabsExpandableListFragment.this.mList.getExpandableListPosition(n);
                if (ExpandableListView.getPackedPositionType((long)l2) != 1) {
                    return null;
                }
                int n3 = ExpandableListView.getPackedPositionGroup((long)l2);
                Object object = expandableListAdapter.getChild(n3, n2 = ExpandableListView.getPackedPositionChild((long)l2));
                if (object instanceof TabsAccessor.RemoteTab) {
                    TabsAccessor.RemoteTab remoteTab = (TabsAccessor.RemoteTab)object;
                    HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                    homeContextMenuInfo.url = remoteTab.url;
                    homeContextMenuInfo.title = remoteTab.title;
                    return homeContextMenuInfo;
                }
                return null;
            }
        });
        this.registerForContextMenu((View)this.mList);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mEmptyView = null;
        if (this.mSyncStatusListener != null) {
            FirefoxAccounts.removeSyncStatusListener(this.mSyncStatusListener);
            this.mSyncStatusListener = null;
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new RemoteTabsExpandableListAdapter(R.layout.home_remote_tabs_group, R.layout.home_remote_tabs_child, null);
        this.mList.setAdapter((ExpandableListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    private void updateUiFromClients(List<TabsAccessor.RemoteClient> list) {
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < this.mList.getExpandableListAdapter().getGroupCount(); ++i) {
                this.mList.expandGroup(i);
            }
            return;
        }
        if (this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_remote_tabs_empty);
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView.setText(R.string.home_remote_tabs_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    private class RemoteTabsSyncListener
    implements FirefoxAccounts.SyncStatusListener {
        private RemoteTabsSyncListener() {
        }

        @Override
        public Context getContext() {
            return RemoteTabsExpandableListFragment.this.getActivity();
        }

        @Override
        public Account getAccount() {
            return FirefoxAccounts.getFirefoxAccount(this.getContext());
        }

        @Override
        public void onSyncStarted() {
        }

        @Override
        public void onSyncFinished() {
            RemoteTabsExpandableListFragment.this.mRefreshLayout.setRefreshing(false);
        }
    }

    private class RemoteTabsRefreshListener
    implements GeckoSwipeRefreshLayout.OnRefreshListener {
        private RemoteTabsRefreshListener() {
        }

        @Override
        public void onRefresh() {
            if (FirefoxAccounts.firefoxAccountsExist((Context)RemoteTabsExpandableListFragment.this.getActivity())) {
                Account account = FirefoxAccounts.getFirefoxAccount((Context)RemoteTabsExpandableListFragment.this.getActivity());
                FirefoxAccounts.requestSync(account, FirefoxAccounts.FORCE, STAGES_TO_SYNC_ON_REFRESH, null);
            } else {
                Log.wtf((String)RemoteTabsExpandableListFragment.LOGTAG, (String)"No Firefox Account found; this should never happen. Ignoring.");
                RemoteTabsExpandableListFragment.this.mRefreshLayout.setRefreshing(false);
            }
        }
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new RemoteTabsCursorLoader((Context)RemoteTabsExpandableListFragment.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            List<TabsAccessor.RemoteClient> list = TabsAccessor.getClientsFromCursor(cursor);
            RemoteTabsExpandableListFragment.this.mAdapter.replaceClients(list);
            RemoteTabsExpandableListFragment.this.updateUiFromClients(list);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            RemoteTabsExpandableListFragment.this.mAdapter.replaceClients(null);
        }
    }

    private static class RemoteTabsCursorLoader
    extends SimpleCursorLoader {
        public RemoteTabsCursorLoader(Context context) {
            super(context);
        }

        @Override
        public Cursor loadCursor() {
            return TabsAccessor.getRemoteTabsCursor(this.getContext());
        }
    }
}

