/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorActivity;
import android.accounts.AccountManager;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.io.UnsupportedEncodingException;
import org.json.simple.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.JPakeNoActivePairingException;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.sync.setup.activities.AccountActivity;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;
import org.mozilla.gecko.sync.setup.activities.SetupFailureActivity;
import org.mozilla.gecko.sync.setup.activities.SetupSuccessActivity;
import org.mozilla.gecko.sync.setup.activities.WebViewActivity;

public class SetupSyncActivity
extends AccountAuthenticatorActivity {
    private static final String LOG_TAG = "SetupSync";
    private boolean pairWithPin = false;
    private EditText row1;
    private EditText row2;
    private EditText row3;
    private Button connectButton;
    private LinearLayout pinError;
    private TextView pinTextView1;
    private TextView pinTextView2;
    private TextView pinTextView3;
    private JPakeClient jClient;
    private AccountManager mAccountManager;
    private Context mContext;

    public void onCreate(Bundle bundle) {
        ActivityUtils.prepareLogging();
        Logger.info(LOG_TAG, "Called SetupSyncActivity.onCreate.");
        super.onCreate(bundle);
        this.mContext = this.getApplicationContext();
        Logger.debug(LOG_TAG, "AccountManager.get(" + this.mContext + ")");
        this.mAccountManager = AccountManager.get((Context)this.mContext);
        Window window = this.getWindow();
        window.addFlags(128);
        Logger.debug(LOG_TAG, "Successfully set screen-on flag.");
    }

    public void onResume() {
        ActivityUtils.prepareLogging();
        Logger.info(LOG_TAG, "Called SetupSyncActivity.onResume.");
        super.onResume();
        if (!this.hasInternet()) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SetupSyncActivity.this.setContentView(R.layout.sync_setup_nointernet);
                }
            });
            return;
        }
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                ActivityUtils.prepareLogging();
                Account[] accountArray = SetupSyncActivity.this.mAccountManager.getAccountsByType("org.mozilla.fennec_sync");
                SetupSyncActivity.this.finishResume(accountArray);
            }
        });
    }

    public void finishResume(Account[] accountArray) {
        Logger.debug(LOG_TAG, "Finishing Resume after fetching accounts.");
        if (accountArray.length == 0) {
            Logger.debug(LOG_TAG, "No accounts; starting J-PAKE receiver.");
            this.displayReceiveNoPin();
            if (this.jClient != null) {
                this.jClient.finished = true;
            }
            this.jClient = new JPakeClient(this);
            this.jClient.receiveNoPin();
            return;
        }
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            Logger.debug(LOG_TAG, "SetupSync with extras.");
            boolean bl = bundle.getBoolean("isSetup");
            if (!bl) {
                Logger.debug(LOG_TAG, "Account exists; Pair a Device started.");
                this.pairWithPin = true;
                this.displayPairWithPin();
                return;
            }
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Logger.debug(SetupSyncActivity.LOG_TAG, "Only one account supported. Redirecting.");
                Toast toast = Toast.makeText((Context)SetupSyncActivity.this.mContext, (int)R.string.sync_notification_oneaccount, (int)1);
                toast.show();
                SetupSyncActivity.this.finish();
            }
        });
    }

    public void onPause() {
        super.onPause();
        if (this.jClient != null) {
            this.jClient.abort("jpake.error.userabort");
        }
        if (this.pairWithPin) {
            this.finish();
        }
    }

    public void onNewIntent(Intent intent) {
        Logger.debug(LOG_TAG, "Started SetupSyncActivity with new intent.");
        this.setIntent(intent);
    }

    public void onDestroy() {
        Logger.debug(LOG_TAG, "onDestroy() called.");
        super.onDestroy();
    }

    public void manualClickHandler(View view) {
        Intent intent = new Intent((Context)this, AccountActivity.class);
        intent.setFlags(65536);
        this.startActivityForResult(intent, 0);
        this.overridePendingTransition(0, 0);
    }

    public void cancelClickHandler(View view) {
        this.finish();
    }

    public void connectClickHandler(View view) {
        Logger.debug(LOG_TAG, "Connect clicked.");
        this.pinError.setVisibility(4);
        this.enablePinEntry(false);
        this.connectButton.requestFocus();
        this.activateButton(this.connectButton, false);
        String string2 = this.row1.getText().toString();
        string2 = string2 + this.row2.getText().toString() + this.row3.getText().toString();
        if (this.jClient != null) {
            this.jClient.finished = true;
        }
        this.jClient = new JPakeClient(this);
        this.jClient.pairWithPin(string2);
    }

    public void showClickHandler(View view) {
        Uri uri = null;
        uri = this.pairWithPin ? Uri.parse((String)"https://support.mozilla.org/kb/find-code-to-add-device-to-firefox-sync") : Uri.parse((String)"https://support.mozilla.org/kb/add-a-device-to-firefox-sync");
        Intent intent = new Intent((Context)this, WebViewActivity.class);
        intent.setData(uri);
        this.startActivity(intent);
    }

    public void displayPin(String string2) {
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Asked to display null pin.");
            return;
        }
        int n = string2.length() / 3;
        final String string3 = string2.substring(0, n);
        final String string4 = string2.substring(n, 2 * n);
        final String string5 = string2.substring(2 * n, string2.length());
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                TextView textView = SetupSyncActivity.this.pinTextView1;
                TextView textView2 = SetupSyncActivity.this.pinTextView2;
                TextView textView3 = SetupSyncActivity.this.pinTextView3;
                if (textView == null || textView2 == null || textView3 == null) {
                    Logger.warn(SetupSyncActivity.LOG_TAG, "Couldn't find view to display PIN.");
                    return;
                }
                textView.setText((CharSequence)string3);
                textView.setContentDescription((CharSequence)string3.replaceAll("\\B", ", "));
                textView2.setText((CharSequence)string4);
                textView2.setContentDescription((CharSequence)string4.replaceAll("\\B", ", "));
                textView3.setText((CharSequence)string5);
                textView3.setContentDescription((CharSequence)string5.replaceAll("\\B", ", "));
            }
        });
    }

    public void displayAbort(String string2) {
        if (!"jpake.error.userabort".equals(string2) && !this.hasInternet()) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SetupSyncActivity.this.setContentView(R.layout.sync_setup_nointernet);
                }
            });
            return;
        }
        if (this.pairWithPin) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SetupSyncActivity.this.enablePinEntry(true);
                    SetupSyncActivity.this.row1.setText((CharSequence)"");
                    SetupSyncActivity.this.row2.setText((CharSequence)"");
                    SetupSyncActivity.this.row3.setText((CharSequence)"");
                    SetupSyncActivity.this.row1.requestFocus();
                    SetupSyncActivity.this.pinError.setVisibility(0);
                }
            });
            return;
        }
        Logger.debug(LOG_TAG, "abort reason: " + string2);
        if (!"jpake.error.userabort".equals(string2)) {
            this.jClient = new JPakeClient(this);
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SetupSyncActivity.this.displayReceiveNoPin();
                    SetupSyncActivity.this.jClient.receiveNoPin();
                }
            });
        }
    }

    protected JSONObject makeAccountJSON(String string2, String string3, String string4, String string5) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject = new JSONObject();
        jSONObject2.put("synckey", string4);
        jSONObject2.put("account", string2);
        jSONObject2.put("password", string3);
        jSONObject2.put("serverURL", string5);
        if (Logger.LOG_PERSONAL_INFORMATION) {
            Logger.pii(LOG_TAG, "Extracted account data: " + jSONObject.toJSONString());
        }
        return jSONObject;
    }

    public void onPaired() {
        Account[] accountArray = this.mAccountManager.getAccountsByType("org.mozilla.fennec_sync");
        if (accountArray.length == 0) {
            Logger.error(LOG_TAG, "No accounts present.");
            this.displayAbort("jpake.error.invalid");
            return;
        }
        Account account = accountArray[0];
        String string2 = account.name;
        String string3 = this.mAccountManager.getPassword(account);
        String string4 = this.mAccountManager.getUserData(account, "option.synckey");
        String string5 = this.mAccountManager.getUserData(account, "option.serverUrl");
        JSONObject jSONObject = this.makeAccountJSON(string2, string3, string4, string5);
        try {
            this.jClient.sendAndComplete(jSONObject);
        }
        catch (JPakeNoActivePairingException jPakeNoActivePairingException) {
            Logger.error(LOG_TAG, "No active J-PAKE pairing.", jPakeNoActivePairingException);
            this.displayAbort("jpake.error.invalid");
        }
    }

    public void onPairingStart() {
        if (!this.pairWithPin) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SetupSyncActivity.this.setContentView(R.layout.sync_setup_jpake_waiting);
                }
            });
            return;
        }
    }

    public void onComplete(JSONObject jSONObject) {
        if (!this.pairWithPin) {
            String string2 = (String)jSONObject.get((Object)"account");
            String string3 = (String)jSONObject.get((Object)"password");
            String string4 = (String)jSONObject.get((Object)"synckey");
            String string5 = (String)jSONObject.get((Object)"serverURL");
            try {
                string3 = Utils.decodeUTF8(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.warn(LOG_TAG, "Unsupported encoding when decoding UTF-8 ASCII J-PAKE message. Ignoring.");
            }
            SyncAccounts.SyncAccountParameters syncAccountParameters = new SyncAccounts.SyncAccountParameters(this.mContext, this.mAccountManager, string2, string4, string3, string5);
            this.createAccountOnThread(syncAccountParameters);
        } else {
            this.displayResultAndFinish(true);
        }
    }

    private void displayResultAndFinish(final boolean bl) {
        this.jClient = null;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int n = bl ? -1 : 0;
                SetupSyncActivity.this.setResult(n);
                SetupSyncActivity.this.displayResult(bl);
            }
        });
    }

    private void createAccountOnThread(final SyncAccounts.SyncAccountParameters syncAccountParameters) {
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                Account account = SyncAccounts.createSyncAccount(syncAccountParameters);
                boolean bl2 = bl = account != null;
                if (bl) {
                    Bundle bundle = new Bundle();
                    bundle.putString("authAccount", syncAccountParameters.username);
                    bundle.putString("accountType", "org.mozilla.fennec_sync");
                    bundle.putString("authtoken", "org.mozilla.fennec_sync");
                    SetupSyncActivity.this.setAccountAuthenticatorResult(bundle);
                }
                SetupSyncActivity.this.displayResultAndFinish(bl);
            }
        });
    }

    private void activateButton(Button button, boolean bl) {
        button.setEnabled(bl);
        button.setClickable(bl);
    }

    private void enablePinEntry(boolean bl) {
        this.row1.setEnabled(bl);
        this.row2.setEnabled(bl);
        this.row3.setEnabled(bl);
    }

    private void displayResult(boolean bl) {
        Intent intent = null;
        if (bl) {
            intent = new Intent(this.mContext, SetupSuccessActivity.class);
            intent.setFlags(196608);
            intent.putExtra("isSetup", !this.pairWithPin);
            this.startActivity(intent);
            this.finish();
        } else {
            intent = new Intent(this.mContext, SetupFailureActivity.class);
            intent.putExtra("isAccountError", true);
            intent.setFlags(196608);
            intent.putExtra("isSetup", !this.pairWithPin);
            this.startActivity(intent);
        }
    }

    private boolean pinEntryCompleted() {
        return this.row1.length() == 4 && this.row2.length() == 4 && this.row3.length() == 4;
    }

    private boolean hasInternet() {
        Logger.debug(LOG_TAG, "Checking internet connectivity.");
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            Logger.debug(LOG_TAG, networkInfo + " is connected.");
            return true;
        }
        Logger.debug(LOG_TAG, "No connected networks.");
        return false;
    }

    private void displayPairWithPin() {
        Logger.debug(LOG_TAG, "PairWithPin initiated.");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SetupSyncActivity.this.setContentView(R.layout.sync_setup_pair);
                SetupSyncActivity.this.connectButton = (Button)SetupSyncActivity.this.findViewById(R.id.pair_button_connect);
                SetupSyncActivity.this.pinError = (LinearLayout)SetupSyncActivity.this.findViewById(R.id.pair_error);
                SetupSyncActivity.this.row1 = (EditText)SetupSyncActivity.this.findViewById(R.id.pair_row1);
                SetupSyncActivity.this.row2 = (EditText)SetupSyncActivity.this.findViewById(R.id.pair_row2);
                SetupSyncActivity.this.row3 = (EditText)SetupSyncActivity.this.findViewById(R.id.pair_row3);
                SetupSyncActivity.this.row1.addTextChangedListener(new TextWatcher(){

                    public void afterTextChanged(Editable editable) {
                        SetupSyncActivity.this.activateButton(SetupSyncActivity.this.connectButton, SetupSyncActivity.this.pinEntryCompleted());
                        if (editable.length() == 4) {
                            SetupSyncActivity.this.row2.requestFocus();
                        }
                    }

                    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }

                    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }
                });
                SetupSyncActivity.this.row2.addTextChangedListener(new TextWatcher(){

                    public void afterTextChanged(Editable editable) {
                        SetupSyncActivity.this.activateButton(SetupSyncActivity.this.connectButton, SetupSyncActivity.this.pinEntryCompleted());
                        if (editable.length() == 4) {
                            SetupSyncActivity.this.row3.requestFocus();
                        }
                    }

                    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }

                    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }
                });
                SetupSyncActivity.this.row3.addTextChangedListener(new TextWatcher(){

                    public void afterTextChanged(Editable editable) {
                        SetupSyncActivity.this.activateButton(SetupSyncActivity.this.connectButton, SetupSyncActivity.this.pinEntryCompleted());
                    }

                    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }

                    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }
                });
                SetupSyncActivity.this.row1.requestFocus();
            }
        });
    }

    private void displayReceiveNoPin() {
        Logger.debug(LOG_TAG, "ReceiveNoPin initiated");
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SetupSyncActivity.this.setContentView(R.layout.sync_setup);
                SetupSyncActivity.this.pinTextView1 = (TextView)SetupSyncActivity.this.findViewById(R.id.text_pin1);
                SetupSyncActivity.this.pinTextView2 = (TextView)SetupSyncActivity.this.findViewById(R.id.text_pin2);
                SetupSyncActivity.this.pinTextView3 = (TextView)SetupSyncActivity.this.findViewById(R.id.text_pin3);
            }
        });
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        switch (n2) {
            case -1: {
                this.finish();
            }
        }
    }
}

