/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.SharedPreferences;
import android.util.Log;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.util.JSONUtils;

public class PrefUtils {
    private static final String LOGTAG = "GeckoPrefUtils";

    public static Set<String> getStringSet(SharedPreferences sharedPreferences, String string, Set<String> set) {
        if (!sharedPreferences.contains(string)) {
            return set;
        }
        if (AppConstants.Versions.preHC) {
            return PrefUtils.getFromJSON(sharedPreferences, string);
        }
        try {
            return sharedPreferences.getStringSet(string, new HashSet());
        }
        catch (ClassCastException classCastException) {
            Set<String> set2 = PrefUtils.getFromJSON(sharedPreferences, string);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            PrefUtils.putStringSet(editor, string, set2).apply();
            return set2;
        }
    }

    private static Set<String> getFromJSON(SharedPreferences sharedPreferences, String string) {
        try {
            String string2 = sharedPreferences.getString(string, "[]");
            return JSONUtils.parseStringSet(new JSONArray(string2));
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"Unable to parse JSON", (Throwable)jSONException);
            return new HashSet<String>();
        }
    }

    public static SharedPreferences.Editor putStringSet(SharedPreferences.Editor editor, String string, Set<String> set) {
        if (AppConstants.Versions.preHC) {
            JSONArray jSONArray = new JSONArray(set);
            editor.putString(string, jSONArray.toString()).apply();
        } else {
            editor.putStringSet(string, set).apply();
        }
        return editor;
    }
}

