/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.view.View;
import com.nineoldandroids.animation.PreHoneycombCompat;
import com.nineoldandroids.animation.PropertyValuesHolder;
import com.nineoldandroids.animation.TypeEvaluator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.util.Property;
import com.nineoldandroids.view.animation.AnimatorProxy;
import java.util.HashMap;
import java.util.Map;

public final class ObjectAnimator
extends ValueAnimator {
    private static final boolean DBG = false;
    private static final Map<String, Property> PROXY_PROPERTIES = new HashMap<String, Property>();
    private Object mTarget;
    private String mPropertyName;
    private Property mProperty;

    public void setPropertyName(String string) {
        if (this.mValues != null) {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            String string2 = propertyValuesHolder.getPropertyName();
            propertyValuesHolder.setPropertyName(string);
            this.mValuesMap.remove(string2);
            this.mValuesMap.put(string, propertyValuesHolder);
        }
        this.mPropertyName = string;
        this.mInitialized = false;
    }

    public void setProperty(Property property) {
        if (this.mValues != null) {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            String string = propertyValuesHolder.getPropertyName();
            propertyValuesHolder.setProperty(property);
            this.mValuesMap.remove(string);
            this.mValuesMap.put(this.mPropertyName, propertyValuesHolder);
        }
        if (this.mProperty != null) {
            this.mPropertyName = property.getName();
        }
        this.mProperty = property;
        this.mInitialized = false;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public ObjectAnimator() {
    }

    private ObjectAnimator(Object object, String string) {
        this.mTarget = object;
        this.setPropertyName(string);
    }

    private <T> ObjectAnimator(T t, Property<T, ?> property) {
        this.mTarget = t;
        this.setProperty(property);
    }

    public static ObjectAnimator ofInt(Object object, String string, int ... nArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string);
        objectAnimator.setIntValues(nArray);
        return objectAnimator;
    }

    public static <T> ObjectAnimator ofInt(T t, Property<T, Integer> property, int ... nArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setIntValues(nArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofFloat(Object object, String string, float ... fArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string);
        objectAnimator.setFloatValues(fArray);
        return objectAnimator;
    }

    public static <T> ObjectAnimator ofFloat(T t, Property<T, Float> property, float ... fArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setFloatValues(fArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofObject(Object object, String string, TypeEvaluator typeEvaluator, Object ... objectArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string);
        objectAnimator.setObjectValues(objectArray);
        objectAnimator.setEvaluator(typeEvaluator);
        return objectAnimator;
    }

    public static <T, V> ObjectAnimator ofObject(T t, Property<T, V> property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setObjectValues(VArray);
        objectAnimator.setEvaluator(typeEvaluator);
        return objectAnimator;
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object object, PropertyValuesHolder ... propertyValuesHolderArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        objectAnimator.mTarget = object;
        objectAnimator.setValues(propertyValuesHolderArray);
        return objectAnimator;
    }

    @Override
    public void setIntValues(int ... nArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofInt(this.mProperty, nArray));
            } else {
                this.setValues(PropertyValuesHolder.ofInt(this.mPropertyName, nArray));
            }
        } else {
            super.setIntValues(nArray);
        }
    }

    @Override
    public void setFloatValues(float ... fArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofFloat(this.mProperty, fArray));
            } else {
                this.setValues(PropertyValuesHolder.ofFloat(this.mPropertyName, fArray));
            }
        } else {
            super.setFloatValues(fArray);
        }
    }

    @Override
    public void setObjectValues(Object ... objectArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofObject(this.mProperty, (TypeEvaluator)null, objectArray));
            } else {
                this.setValues(PropertyValuesHolder.ofObject(this.mPropertyName, (TypeEvaluator)null, objectArray));
            }
        } else {
            super.setObjectValues(objectArray);
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    void initAnimation() {
        if (!this.mInitialized) {
            if (this.mProperty == null && AnimatorProxy.NEEDS_PROXY && this.mTarget instanceof View && PROXY_PROPERTIES.containsKey(this.mPropertyName)) {
                this.setProperty(PROXY_PROPERTIES.get(this.mPropertyName));
            }
            int n = this.mValues.length;
            for (int i = 0; i < n; ++i) {
                this.mValues[i].setupSetterAndGetter(this.mTarget);
            }
            super.initAnimation();
        }
    }

    @Override
    public ObjectAnimator setDuration(long l) {
        super.setDuration(l);
        return this;
    }

    public Object getTarget() {
        return this.mTarget;
    }

    @Override
    public void setTarget(Object object) {
        if (this.mTarget != object) {
            Object object2 = this.mTarget;
            this.mTarget = object;
            if (object2 != null && object != null && object2.getClass() == object.getClass()) {
                return;
            }
            this.mInitialized = false;
        }
    }

    @Override
    public void setupStartValues() {
        this.initAnimation();
        int n = this.mValues.length;
        for (int i = 0; i < n; ++i) {
            this.mValues[i].setupStartValue(this.mTarget);
        }
    }

    @Override
    public void setupEndValues() {
        this.initAnimation();
        int n = this.mValues.length;
        for (int i = 0; i < n; ++i) {
            this.mValues[i].setupEndValue(this.mTarget);
        }
    }

    @Override
    void animateValue(float f) {
        super.animateValue(f);
        int n = this.mValues.length;
        for (int i = 0; i < n; ++i) {
            this.mValues[i].setAnimatedValue(this.mTarget);
        }
    }

    @Override
    public ObjectAnimator clone() {
        ObjectAnimator objectAnimator = (ObjectAnimator)super.clone();
        return objectAnimator;
    }

    @Override
    public String toString() {
        String string = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.mTarget;
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                string = string + "\n    " + this.mValues[i].toString();
            }
        }
        return string;
    }

    static {
        PROXY_PROPERTIES.put("alpha", PreHoneycombCompat.ALPHA);
        PROXY_PROPERTIES.put("pivotX", PreHoneycombCompat.PIVOT_X);
        PROXY_PROPERTIES.put("pivotY", PreHoneycombCompat.PIVOT_Y);
        PROXY_PROPERTIES.put("translationX", PreHoneycombCompat.TRANSLATION_X);
        PROXY_PROPERTIES.put("translationY", PreHoneycombCompat.TRANSLATION_Y);
        PROXY_PROPERTIES.put("rotation", PreHoneycombCompat.ROTATION);
        PROXY_PROPERTIES.put("rotationX", PreHoneycombCompat.ROTATION_X);
        PROXY_PROPERTIES.put("rotationY", PreHoneycombCompat.ROTATION_Y);
        PROXY_PROPERTIES.put("scaleX", PreHoneycombCompat.SCALE_X);
        PROXY_PROPERTIES.put("scaleY", PreHoneycombCompat.SCALE_Y);
        PROXY_PROPERTIES.put("scrollX", PreHoneycombCompat.SCROLL_X);
        PROXY_PROPERTIES.put("scrollY", PreHoneycombCompat.SCROLL_Y);
        PROXY_PROPERTIES.put("x", PreHoneycombCompat.X);
        PROXY_PROPERTIES.put("y", PreHoneycombCompat.Y);
    }
}

