/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.search.R;
import org.mozilla.search.providers.SearchEngine;

public class PostSearchFragment
extends Fragment {
    private static final String LOG_TAG = "PostSearchFragment";
    private SearchEngine engine;
    private ProgressBar progressBar;
    private WebView webview;
    private View errorView;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.search_fragment_post_search, viewGroup, false);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
        this.webview = (WebView)view.findViewById(R.id.webview);
        this.webview.setWebChromeClient((WebChromeClient)new ChromeClient());
        this.webview.setWebViewClient((WebViewClient)new ResultsWebViewClient());
        this.webview.getSettings().setJavaScriptEnabled(true);
        return view;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.webview.setWebChromeClient(null);
        this.webview.setWebViewClient(null);
        this.webview = null;
        this.progressBar = null;
    }

    public void startSearch(SearchEngine searchEngine, String string2) {
        this.engine = searchEngine;
        String string3 = searchEngine.resultsUriForQuery(string2);
        if (!TextUtils.equals((CharSequence)this.webview.getUrl(), (CharSequence)string3)) {
            this.webview.loadUrl("about:blank");
            this.webview.loadUrl(string3);
        }
    }

    private class ChromeClient
    extends WebChromeClient {
        private ChromeClient() {
        }

        public void onReceivedTitle(WebView webView, String string2) {
            webView.loadUrl(PostSearchFragment.this.engine.getInjectableJs());
        }

        public void onProgressChanged(WebView webView, int n) {
            if (n < 100) {
                if (PostSearchFragment.this.progressBar.getVisibility() == 4) {
                    PostSearchFragment.this.progressBar.setVisibility(0);
                }
                PostSearchFragment.this.progressBar.setProgress(n);
            } else {
                PostSearchFragment.this.progressBar.setVisibility(4);
            }
        }
    }

    private class ResultsWebViewClient
    extends WebViewClient {
        private boolean networkError;

        private ResultsWebViewClient() {
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            this.networkError = false;
            if (TextUtils.equals((CharSequence)string2, (CharSequence)"about:blank") || PostSearchFragment.this.engine.isSearchResultsPage(string2)) {
                return;
            }
            PostSearchFragment.this.webview.stopLoading();
            Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.LOAD_URL, (TelemetryContract.Method)TelemetryContract.Method.CONTENT, (String)"search-result");
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
            intent.setData(Uri.parse((String)string2));
            PostSearchFragment.this.startActivity(intent);
        }

        public void onReceivedError(WebView webView, int n, String string2, String string3) {
            Log.e((String)PostSearchFragment.LOG_TAG, (String)("Error loading search results: " + string2));
            this.networkError = true;
            if (PostSearchFragment.this.errorView == null) {
                ViewStub viewStub = (ViewStub)PostSearchFragment.this.getView().findViewById(R.id.error_view_stub);
                PostSearchFragment.this.errorView = viewStub.inflate();
                ((ImageView)PostSearchFragment.this.errorView.findViewById(R.id.empty_image)).setImageResource(R.drawable.network_error);
                ((TextView)PostSearchFragment.this.errorView.findViewById(R.id.empty_title)).setText(R.string.network_error_title);
                TextView textView = (TextView)PostSearchFragment.this.errorView.findViewById(R.id.empty_message);
                textView.setText(R.string.network_error_message);
                textView.setTextColor(PostSearchFragment.this.getResources().getColor(R.color.network_error_link));
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        PostSearchFragment.this.startActivity(new Intent("android.settings.SETTINGS"));
                    }
                });
            }
        }

        public void onPageFinished(WebView webView, String string2) {
            if (PostSearchFragment.this.errorView != null) {
                PostSearchFragment.this.errorView.setVisibility(this.networkError ? 0 : 8);
                PostSearchFragment.this.webview.setVisibility(this.networkError ? 8 : 0);
            }
        }
    }
}

