/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mozglue;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mozilla.gecko.mozglue.NativeReference;

class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer mBuf;
    private NativeReference mNativeRef;

    protected ByteBufferInputStream(ByteBuffer byteBuffer, NativeReference nativeReference) {
        this.mBuf = byteBuffer;
        this.mNativeRef = nativeReference;
    }

    @Override
    public int available() {
        return this.mBuf.remaining();
    }

    @Override
    public void close() {
        this.mBuf = null;
        this.mNativeRef.release();
    }

    @Override
    public int read() {
        if (!this.mBuf.hasRemaining() || this.mNativeRef.isReleased()) {
            return -1;
        }
        return this.mBuf.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (!this.mBuf.hasRemaining() || this.mNativeRef.isReleased()) {
            return -1;
        }
        n2 = Math.min(n2, this.mBuf.remaining());
        this.mBuf.get(byArray, n, n2);
        return n2;
    }

    @Override
    public long skip(long l) {
        if (l < 0L || this.mNativeRef.isReleased()) {
            return 0L;
        }
        l = Math.min(l, (long)this.mBuf.remaining());
        this.mBuf.position(this.mBuf.position() + (int)l);
        return l;
    }
}

